/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.placer.animator;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.sorter.BlockSorter;
import net.rodofire.easierworldcreator.maths.equation.CubicEquation;
import net.rodofire.easierworldcreator.maths.equation.QuadraticEquation;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class StructurePlaceAnimator {
    private class_5281 world;
    BlockSorter blockSorter;
    private AnimatorTime animatorTime;
    private AnimatorSound animatorSound = AnimatorSound.DEFAULT;
    private class_3545<Integer, Integer> bounds = new class_3545((Object)1, (Object)100);
    private int blocksPerTick = 100;
    private int ticks = 500;
    int ticksPassed;
    private float soundPerTicks = 10.0f;
    private float ax2 = 0.0f;
    private float bx = 0.0f;
    private int c = 0;

    public StructurePlaceAnimator(class_5281 world, BlockSorter blockSorter, AnimatorTime animatorTime) {
        this.world = world;
        this.blockSorter = blockSorter;
        this.animatorTime = animatorTime;
    }

    public class_3545<Integer, Integer> getBounds() {
        return this.bounds;
    }

    public void setBounds(class_3545<Integer, Integer> bounds) {
        this.bounds = bounds;
    }

    public int getBlocksPerTick() {
        return this.blocksPerTick;
    }

    public void setBlocksPerTick(int blocksPerTick) {
        this.blocksPerTick = blocksPerTick;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public AnimatorTime getAnimatorTime() {
        return this.animatorTime;
    }

    public void setAnimatorTime(AnimatorTime animatorTime) {
        this.animatorTime = animatorTime;
    }

    public BlockSorter getAnimatorType() {
        return this.blockSorter;
    }

    public void setAnimatorType(BlockSorter blockSorter) {
        this.blockSorter = blockSorter;
    }

    public class_5281 getWorld() {
        return this.world;
    }

    public void setWorld(class_5281 world) {
        this.world = world;
    }

    public AnimatorSound getAnimatorSound() {
        return this.animatorSound;
    }

    public void setAnimatorSound(AnimatorSound animatorSound) {
        this.animatorSound = animatorSound;
    }

    public float getSoundPerTicks() {
        return this.soundPerTicks;
    }

    public void setSoundPerTicks(float soundPerTicks) {
        this.soundPerTicks = soundPerTicks;
    }

    List<BlockList> convertFromDividedToUnified(List<Set<BlockList>> blockList) {
        ArrayList<BlockList> fusedList = new ArrayList<BlockList>();
        for (Set<BlockList> set : blockList) {
            fusedList.addAll(set);
        }
        return fusedList;
    }

    @Deprecated(forRemoval=true)
    public void placeFromDividedBlockList(List<Set<BlockList>> blockList) {
        if (StructurePlaceAnimator.blockListVerification(blockList)) {
            return;
        }
        Instant start = Instant.now();
        List<BlockList> fusedList = this.convertFromDividedToUnified(blockList);
    }

    public void place(BlockListManager manager) {
        if (StructurePlaceAnimator.blockListVerification(manager.getAllBlockList())) {
            return;
        }
        Instant start = Instant.now();
        OrderedBlockListManager sortedBlockList = manager.getOrdered(this.blockSorter);
        Instant end = Instant.now();
        Duration timeElapsed = Duration.between(start, end);
        Ewc.LOGGER.info("Shape sorted list calculations took : {}ms", (Object)timeElapsed.toMillis());
        this.place(sortedBlockList);
    }

    private static <T> boolean blockListVerification(List<T> blockList) {
        if (blockList == null || blockList.isEmpty()) {
            Ewc.LOGGER.warn("StructureBlockAnimator: blockList is null or empty");
            return true;
        }
        return false;
    }

    public void place(OrderedBlockListManager manager) {
        ArrayList<Integer> randomBlocks = new ArrayList<Integer>();
        int totalBlocks = manager.posSize();
        AtomicReference<Float> soundPlayed = new AtomicReference<Float>(Float.valueOf(0.0f));
        this.calculateBlockPerTicks(totalBlocks, randomBlocks);
        switch (this.animatorSound.ordinal()) {
            case 0: {
                this.soundPerTicks = 0.0f;
                break;
            }
            case 1: {
                this.soundPerTicks = 0.5f;
                break;
            }
            case 2: {
                this.soundPerTicks = Math.min((float)this.blocksPerTick, this.soundPerTicks);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.animatorSound));
            }
        }
        this.ticksPassed = 0;
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            int blocksThisTick;
            if (this.ticksPassed == this.ticks || manager.isPosEmpty()) {
                return;
            }
            soundPlayed.set(Float.valueOf(((Float)soundPlayed.get()).floatValue() + this.soundPerTicks));
            if (this.animatorTime == AnimatorTime.RANDOM_BLOCKS_PER_TICK && !randomBlocks.isEmpty()) {
                blocksThisTick = (Integer)randomBlocks.removeLast();
            } else {
                int block = (int)(this.ax2 * (float)this.ticksPassed * (float)this.ticksPassed + this.bx * (float)this.ticksPassed + (float)this.c);
                blocksThisTick = Math.min(block, manager.posSize());
            }
            for (int i = 0; i < blocksThisTick && !manager.isPosEmpty(); ++i) {
                if (((Float)soundPlayed.get()).floatValue() >= 1.0f) {
                    class_2680 state = manager.getLastBlockState();
                    class_2338 pos = LongPosHelper.decodeBlockPos(manager.getLastBlockPos());
                    this.world.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, (float)class_5819.method_43047().method_39332(20, 100) / 10.0f, (float)class_5819.method_43047().method_39332(5, 20) / 10.0f);
                    soundPlayed.set(Float.valueOf(((Float)soundPlayed.get()).floatValue() - 1.0f));
                }
                manager.placeLastNDelete(this.world);
            }
            ++this.ticksPassed;
            if (this.ticksPassed == this.ticks && !manager.isPosEmpty()) {
                int left = manager.posSize();
                Ewc.LOGGER.info("All ticks completed, but {} blocks are still unplaced. Placing remaining blocks in final tick.", (Object)left);
                manager.placeAllNDelete(this.world);
                manager.clear();
            }
        });
    }

    private void calculateBlockPerTicks(int totalBlocks, List<Integer> randomBlocks) {
        switch (this.animatorTime.ordinal()) {
            case 4: {
                if (this.ticks == 0) {
                    this.ticks = 1;
                }
                if (this.ticks > totalBlocks) {
                    this.ticks = totalBlocks;
                }
                this.c = Math.max(1, totalBlocks / this.ticks);
                break;
            }
            case 5: {
                int start = (Integer)this.bounds.method_15442();
                int end = (Integer)this.bounds.method_15441();
                if (start < 1) {
                    start = 1;
                }
                if (end < 1) {
                    end = 1;
                }
                this.ticks = (int)Math.ceil((double)(2 * totalBlocks) / (double)(start + end));
                this.bx = (float)(end - start) / (float)(this.ticks - 1);
                this.c = start;
                break;
            }
            case 6: {
                float c;
                float b;
                float a;
                QuadraticEquation quadraticEquation;
                class_3545<Float, Float> result;
                int start = (Integer)this.bounds.method_15442();
                int end = (Integer)this.bounds.method_15441();
                if (start < 1) {
                    start = 1;
                }
                if (end < 1) {
                    end = 1;
                }
                if ((result = (quadraticEquation = new QuadraticEquation(a = (float)(-(4 * start - end)) / 3.0f, b = (float)totalBlocks - (float)(3 * start - end) / 2.0f, c = (float)(-start + end) / 6.0f)).solve()) == null || ((Float)result.method_15441()).floatValue() < 0.0f && ((Float)result.method_15442()).floatValue() < 0.0f) {
                    this.ax2 = 1.0f;
                    return;
                }
                this.ticks = ((Float)result.method_15442()).floatValue() < 0.0f ? (int)Math.ceil(((Float)result.method_15441()).floatValue()) : (int)Math.ceil(((Float)result.method_15442()).floatValue());
                if (this.ticks == 1) {
                    this.c = totalBlocks;
                    return;
                }
                this.ax2 = (float)(end - start) / (float)((this.ticks - 1) * (this.ticks - 1));
                this.c = start;
                break;
            }
            case 3: {
                int randomInt;
                for (int blocksSelected = 0; blocksSelected < totalBlocks; blocksSelected += randomInt) {
                    randomInt = class_5819.method_43047().method_39332(Math.min(totalBlocks - blocksSelected, (Integer)this.bounds.method_15442()), Math.min(totalBlocks - blocksSelected, (Integer)this.bounds.method_15441()));
                    randomBlocks.add(randomInt);
                }
                this.ticks = randomBlocks.size();
                break;
            }
            case 0: {
                if (this.blocksPerTick <= 0) {
                    Ewc.LOGGER.error("StructureBlockAnimator: blocksPerTick is zero or negative");
                    throw new IllegalStateException();
                }
                this.c = this.blocksPerTick;
                this.ticks = (int)Math.ceil((double)totalBlocks / (double)this.blocksPerTick);
                break;
            }
            case 1: {
                if (this.blocksPerTick <= 0) {
                    Ewc.LOGGER.error("StructureBlockAnimator: blocksPerTick is zero or negative");
                    throw new IllegalStateException();
                }
                float a = (float)this.blocksPerTick / 2.0f;
                float b = (float)this.blocksPerTick / 2.0f;
                float c = -totalBlocks;
                QuadraticEquation equation = new QuadraticEquation(a, b, c);
                class_3545<Float, Float> result = equation.solve();
                if (result == null || ((Float)result.method_15441()).floatValue() < 0.0f && ((Float)result.method_15442()).floatValue() < 0.0f) {
                    this.ax2 = 1.0f;
                    return;
                }
                this.ticks = ((Float)result.method_15442()).floatValue() < 0.0f ? (int)Math.ceil(((Float)result.method_15441()).floatValue()) : (int)Math.ceil(((Float)result.method_15442()).floatValue());
                this.bx = this.blocksPerTick;
                break;
            }
            case 2: {
                if (this.blocksPerTick <= 0) {
                    Ewc.LOGGER.error("StructureBlockAnimator: blocksPerTick is zero or negative");
                    throw new IllegalStateException();
                }
                float a = (float)this.blocksPerTick / 3.0f;
                float b = (float)this.blocksPerTick / 2.0f;
                float c = (float)this.blocksPerTick / 6.0f;
                float d = -totalBlocks;
                CubicEquation equation = new CubicEquation();
                equation.solve(a, b, c, d);
                this.ticks = equation.x1 > 1.0 ? (int)Math.ceil(equation.x1) : (equation.x2 > 1.0 ? (int)Math.ceil(equation.x2) : (equation.x3 > 1.0 ? (int)Math.ceil(equation.x3) : 2000));
                this.ax2 = this.blocksPerTick;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.animatorTime));
            }
        }
    }

    public static enum AnimatorSound {
        NO_SOUND,
        DEFAULT,
        NUMBER_PER_TICK;

    }

    public static enum AnimatorTime {
        CONSTANT_BLOCKS_PER_TICK,
        LINEAR_BLOCK_PER_TICK,
        QUADRATIC_BLOCK_PER_TICK,
        RANDOM_BLOCKS_PER_TICK,
        CONSTANT_TICKS,
        LINEAR_TICKS,
        QUADRATIC_TICKS;

    }
}

