/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.rotations;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class Rotator {
    private class_2338 centerPos = new class_2338(0, 0, 0);
    private int yRotation = 0;
    private int zRotation = 0;
    private int secondYRotation = 0;
    private double cosY2 = 1.0;
    private double cosY = 1.0;
    private double cosZ = 1.0;
    private double sinY = 0.0;
    private double sinY2 = 0.0;
    private double sinZ = 0.0;

    public Rotator(class_2338 centerPos, int yRotation, int zRotation, int secondYRotation) {
        this.centerPos = centerPos;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.secondYRotation = secondYRotation;
        this.getRotations(yRotation, zRotation, secondYRotation);
    }

    public Rotator(int yRotation, int zRotation, int secondYRotation) {
        this.getRotations(yRotation, zRotation, secondYRotation);
    }

    public Rotator(class_2338 centerPos, int yRotation, int zRotation) {
        this.centerPos = centerPos;
        this.getRotations(yRotation, zRotation, 0);
    }

    public Rotator(class_2338 centerPos, int yRotation) {
        this.centerPos = centerPos;
        this.getRotations(yRotation, 0, 0);
    }

    public Rotator(class_2338 centerPos) {
        this.centerPos = centerPos;
    }

    public Rotator() {
        this.getRotations(0, 0, 0);
    }

    public void setYRotation(int yRotation) {
        this.yRotation = yRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public int getYRotation() {
        return this.yRotation;
    }

    public int getZRotation() {
        return this.zRotation;
    }

    public void setZRotation(int yRotation) {
        this.zRotation = yRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public int getSecondYRotation() {
        return this.secondYRotation;
    }

    public void setSecondYRotation(int secondYRotation) {
        this.secondYRotation = secondYRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public void addZRotation(int YRotation) {
        this.yRotation += YRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public void addYRotation(int yRotation) {
        this.zRotation += yRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public void addSecondZRotation(int secondYRotation) {
        this.secondYRotation += secondYRotation;
        this.getRotations(this.yRotation, this.zRotation, this.secondYRotation);
    }

    public class_2338 getCenterPos() {
        return this.centerPos;
    }

    public Rotator setCenterPos(class_2338 centerPos) {
        this.centerPos = centerPos;
        return this;
    }

    private void getRotations(int yRotation, int zRotation, int secondYRotation) {
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.secondYRotation = secondYRotation;
        this.cosY = FastMaths.getFastCos(yRotation);
        this.sinY = FastMaths.getFastSin(yRotation);
        this.cosZ = FastMaths.getFastCos(zRotation);
        this.sinZ = FastMaths.getFastSin(zRotation);
        this.cosY2 = FastMaths.getFastCos(secondYRotation);
        this.sinY2 = FastMaths.getFastSin(secondYRotation);
    }

    public LongArrayList getAll(LongArrayList pos) {
        for (int i = 0; i < pos.size(); ++i) {
            pos.set(i, this.get(pos.getLong(i)));
        }
        return pos;
    }

    public long get(long pos) {
        int[] intPos = LongPosHelper.decodeBlockPos2Array(pos);
        float x_rot1 = (float)((double)intPos[0] * this.cosY - (double)intPos[2] * this.sinY);
        float z_rot1 = (float)((double)intPos[0] * this.sinY + (double)intPos[2] * this.cosY);
        float x_rot_z = (float)((double)x_rot1 * this.cosZ - (double)intPos[1] * this.sinZ);
        float y_rot_z = (float)((double)x_rot1 * this.sinZ + (double)intPos[1] * this.cosZ);
        float x_final = (float)((double)x_rot_z * this.cosY2 - (double)z_rot1 * this.sinY2);
        float z_final = (float)((double)x_rot_z * this.sinY2 + (double)z_rot1 * this.cosY2);
        return LongPosHelper.encodeBlockPos((int)x_final + this.centerPos.method_10263(), (int)y_rot_z + this.centerPos.method_10264(), (int)z_final + this.centerPos.method_10260());
    }

    public long get(double x, double y, double z) {
        double x_rot1 = x * this.cosY - z * this.sinY;
        double z_rot1 = x * this.sinY + z * this.cosY;
        double x_rot_z = x_rot1 * this.cosZ - y * this.sinZ;
        double y_rot_z = x_rot1 * this.sinZ + y * this.cosZ;
        double x_final = x_rot_z * this.cosY2 - z_rot1 * this.sinY2;
        double z_final = x_rot_z * this.sinY2 + z_rot1 * this.cosY2;
        return LongPosHelper.encodeBlockPos((int)x_final + this.centerPos.method_10263(), (int)y_rot_z + this.centerPos.method_10264(), (int)z_final + this.centerPos.method_10260());
    }

    public long getRaw(long pos) {
        int[] intPos = LongPosHelper.decodeBlockPos2Array(pos);
        float x_rot1 = (float)((double)intPos[0] * this.cosY - (double)intPos[2] * this.sinY);
        float z_rot1 = (float)((double)intPos[0] * this.sinY + (double)intPos[2] * this.cosY);
        float x_rot_z = (float)((double)x_rot1 * this.cosZ - (double)intPos[1] * this.sinZ);
        float y_rot_z = (float)((double)x_rot1 * this.sinZ + (double)intPos[1] * this.cosZ);
        float x_final = (float)((double)x_rot_z * this.cosY2 - (double)z_rot1 * this.sinY2);
        float z_final = (float)((double)x_rot_z * this.sinY2 + (double)z_rot1 * this.cosY2);
        return LongPosHelper.encodeBlockPos((int)x_final, (int)y_rot_z, (int)z_final);
    }

    public long getRaw(double x, double y, double z) {
        double x_rot1 = x * this.cosY - z * this.sinY;
        double z_rot1 = x * this.sinY + z * this.cosY;
        double x_rot_z = x_rot1 * this.cosZ - y * this.sinZ;
        double y_rot_z = x_rot1 * this.sinZ + y * this.cosZ;
        double x_final = x_rot_z * this.cosY2 - z_rot1 * this.sinY2;
        double z_final = x_rot_z * this.sinY2 + z_rot1 * this.cosY2;
        return LongPosHelper.encodeBlockPos((int)x_final, (int)y_rot_z, (int)z_final);
    }

    public class_2338 getBlockPos(int[] pos) {
        return this.getBlockPos(pos[0], pos[1], pos[2]);
    }

    public class_2338 getBlockPos(class_2338 pos) {
        return this.getBlockPos(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2338 getBlockPos(class_243 pos) {
        return this.getBlockPos((float)pos.method_10216(), (float)pos.method_10214(), (float)pos.method_10215());
    }

    public class_2338 getBlockPos(float x, float y, float z) {
        float x_rot1 = (float)((double)x * this.cosY - (double)z * this.sinY);
        float z_rot1 = (float)((double)x * this.sinY + (double)z * this.cosY);
        float x_rot_z = (float)((double)x_rot1 * this.cosZ - (double)y * this.sinZ);
        float y_rot_z = (float)((double)x_rot1 * this.sinZ + (double)y * this.cosZ);
        float x_final = (float)((double)x_rot_z * this.cosY2 - (double)z_rot1 * this.sinY2);
        float z_final = (float)((double)x_rot_z * this.sinY2 + (double)z_rot1 * this.cosY2);
        return new class_2338((int)x_final + this.centerPos.method_10263(), (int)y_rot_z + this.centerPos.method_10264(), (int)z_final + this.centerPos.method_10260());
    }

    public class_2338 getRawBlockPos(float x, float y, float z) {
        float x_rot1 = (float)((double)x * this.cosY - (double)z * this.sinY);
        float z_rot1 = (float)((double)x * this.sinY + (double)z * this.cosY);
        float x_rot_z = (float)((double)x_rot1 * this.cosZ - (double)y * this.sinZ);
        float y_rot_z = (float)((double)x_rot1 * this.sinZ + (double)y * this.cosZ);
        float x_final = (float)((double)x_rot_z * this.cosY2 - (double)z_rot1 * this.sinY2);
        float z_final = (float)((double)x_rot_z * this.sinY2 + (double)z_rot1 * this.cosY2);
        return new class_2338((int)x_final, (int)y_rot_z, (int)z_final);
    }
}

