/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.rotations;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2338;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;

public class ShapeRotator {
    private final Rotator rotator;

    public ShapeRotator(Rotator rotator) {
        this.rotator = rotator;
    }

    public class_2338[] get(class_2338[] posList) {
        for (int i = 0; i < posList.length; ++i) {
            posList[i] = this.rotator.getBlockPos(posList[i]);
        }
        return posList;
    }

    public List<class_2338> get(List<class_2338> posList) {
        posList.replaceAll(this.rotator::getBlockPos);
        return posList;
    }

    public long[] get(long[] posList) {
        for (int i = 0; i < posList.length; ++i) {
            posList[i] = this.rotator.get(posList[i]);
        }
        return posList;
    }

    public LongArrayList get(LongArrayList posList) {
        for (int i = 0; i < posList.size(); ++i) {
            posList.set(i, this.rotator.get(posList.getLong(i)));
        }
        return posList;
    }

    public LongOpenHashSet get(LongOpenHashSet posList) {
        LongOpenHashSet ret = new LongOpenHashSet();
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            ret.add(this.rotator.get(pos));
        }
        return posList;
    }

    public BlockListManager get(BlockListManager comparator) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (BlockList blockList : comparator.getAllBlockList()) {
            futures.add(CompletableFuture.runAsync(() -> {
                LongArrayList rotatedPositions = new LongArrayList(blockList.size());
                for (int i = 0; i < blockList.size(); ++i) {
                    rotatedPositions.add(this.rotator.get(blockList.getLongPos(i)));
                }
                BlockList blockList2 = blockList;
                synchronized (blockList2) {
                    blockList.setPosList(rotatedPositions);
                }
            }));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return comparator;
    }

    public DividedBlockListManager getDivided(DividedBlockListManager comparator) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (BlockListManager manager : comparator.getAllManager()) {
            for (BlockList blockList : manager.getAllBlockList()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    LongArrayList rotatedPositions = new LongArrayList(blockList.size());
                    for (int i = 0; i < blockList.size(); ++i) {
                        rotatedPositions.add(this.rotator.get(blockList.getLongPos(i)));
                    }
                    BlockList blockList2 = blockList;
                    synchronized (blockList2) {
                        blockList.setPosList(rotatedPositions);
                    }
                }));
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return comparator;
    }
}

