/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.structure;

import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2633;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3488;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.shape.block.placer.animator.StructurePlaceAnimator;
import net.rodofire.easierworldcreator.structure.StructureUtil;

public class NbtPlacer {
    private final class_5281 world;
    private final class_2960 templateName;
    private StructurePlaceAnimator animator;

    public NbtPlacer(class_5281 world, class_2960 templateName) {
        this.world = world;
        this.templateName = templateName;
    }

    public NbtPlacer(class_5281 world, class_2960 templateName, StructurePlaceAnimator animator) {
        this.world = world;
        this.templateName = templateName;
        this.animator = animator;
    }

    public StructurePlaceAnimator getAnimator() {
        return this.animator;
    }

    public void setAnimator(StructurePlaceAnimator animator) {
        this.animator = animator;
    }

    public void place(class_2338 pos) {
        this.place(1.0f, pos, new class_2338(0, 0, 0), class_2415.field_11302, class_2470.field_11467, true);
    }

    public void place(float integrity, class_2338 pos, class_2338 offset, class_2415 mirror, class_2470 rotation, boolean ignoreEntities) {
        class_3545<class_3499, class_3492> data = this.processCommon(integrity, mirror, rotation, ignoreEntities);
        if (data != null) {
            ((class_3499)data.method_15442()).method_15172((class_5425)this.world, pos, offset, (class_3492)data.method_15441(), this.world.method_8409(), 3);
        }
    }

    public BlockListManager get(float integrity, class_2338 pos, class_2338 offset, class_2415 mirror, class_2470 rotation, boolean ignoreEntities) {
        BlockListManager manager = new BlockListManager();
        class_3545<class_3499, class_3492> data = this.processCommon(integrity, mirror, rotation, ignoreEntities);
        if (data != null) {
            StructureUtil.convertNbtToManager((class_3499)data.method_15442(), manager, (class_3492)data.method_15441(), this.world, offset);
        }
        return manager;
    }

    private class_3545<class_3499, class_3492> processCommon(float integrity, class_2415 mirror, class_2470 rotation, boolean ignoreEntities) {
        Optional optional;
        MinecraftServer server = this.world.method_8503();
        if (server == null) {
            Ewc.LOGGER.error("cannot get structure template, MinecraftServer is null. Structure template: {}", (Object)this.templateName);
            return null;
        }
        class_3485 structureTemplateManager = server.method_27727();
        if (structureTemplateManager == null) {
            return null;
        }
        try {
            optional = structureTemplateManager.method_15094(this.templateName);
        }
        catch (class_151 var6) {
            Ewc.LOGGER.error("cannot get Nbt from Identifier");
            var6.fillInStackTrace();
            return null;
        }
        if (optional.isEmpty()) {
            return null;
        }
        class_3492 structurePlacementData = new class_3492().method_15125(mirror).method_15123(rotation).method_15133(ignoreEntities);
        if (integrity < 1.0f) {
            structurePlacementData.method_16183().method_16184((class_3491)new class_3488(class_3532.method_15363((float)integrity, (float)0.0f, (float)1.0f))).method_15112(class_2633.method_20048((long)this.world.method_8412()));
        }
        return new class_3545((Object)((class_3499)optional.get()), (Object)structurePlacementData);
    }
}

