/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.structure;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.server.MinecraftServer;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.mixin.world.structure.PalettedBlockInfoListMixin;
import net.rodofire.easierworldcreator.mixin.world.structure.StructureTemplateMixin;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.spongepowered.asm.mixin.Unique;

public class SaveNbt {
    public static void saveNbtDuringWorldGen(class_5281 world, List<BlockList> defaultBlockLists, String featureName) {
        HashMap<class_1923, List> chunkBlockInfoMap = new HashMap<class_1923, List>();
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        for (BlockList blocks : defaultBlockLists) {
            class_2680 blockState = blocks.getState();
            LongListIterator longListIterator = blocks.getPosList().iterator();
            while (longListIterator.hasNext()) {
                long pos = (Long)longListIterator.next();
                class_3499.class_3501 structureBlockInfo = new class_3499.class_3501(LongPosHelper.decodeBlockPos(pos), blockState, null);
                SaveNbt.categorize(structureBlockInfo, list, list2, list3);
                class_1923 chunkPos = new class_1923(pos);
                chunkBlockInfoMap.computeIfAbsent(chunkPos, k -> new ArrayList()).add(structureBlockInfo);
            }
        }
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return;
        }
        class_3485 structureTemplateManager = server.method_27727();
        for (Map.Entry entry : chunkBlockInfoMap.entrySet()) {
            class_1923 chunkPos = (class_1923)entry.getKey();
            List blockInfos = (List)entry.getValue();
            List<class_3499.class_3501> combinedList = StructureTemplateMixin.invokeCombineSorted(list, list2, list3);
            ArrayList<class_3499.class_5162> blockInfoLists = new ArrayList<class_3499.class_5162>();
            class_3499.class_5162 palettedBlockInfoList = SaveNbt.createPalettedBlockInfoList(combinedList);
            blockInfoLists.add(palettedBlockInfoList);
            class_2960 templateName = class_2960.method_60655((String)"easierworldcreator", (String)(chunkPos.field_9181 + "-" + chunkPos.field_9180 + "/" + featureName));
            try {
                class_3499 structureTemplate = structureTemplateManager.method_15091(templateName);
                ((StructureTemplateMixin)structureTemplate).getBlockInfoLists().clear();
                ((StructureTemplateMixin)structureTemplate).getBlockInfoLists().addAll(blockInfoLists);
                structureTemplateManager.method_15093(templateName);
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
    }

    private static void categorize(class_3499.class_3501 blockInfo, List<class_3499.class_3501> fullBlocks, List<class_3499.class_3501> blocksWithNbt, List<class_3499.class_3501> otherBlocks) {
        if (blockInfo.comp_1343() != null) {
            blocksWithNbt.add(blockInfo);
        } else if (!blockInfo.comp_1342().method_26204().method_9543() && blockInfo.comp_1342().method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) {
            fullBlocks.add(blockInfo);
        } else {
            otherBlocks.add(blockInfo);
        }
    }

    public static void removeNbtFiles(List<class_2960> nbtList) {
        for (class_2960 nbt : nbtList) {
            try {
                Path filePath = Path.of(nbt.method_12832(), new String[0]);
                Files.delete(filePath);
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
    }

    public static List<class_2960> loadNBTFiles(class_2791 chunk) {
        return SaveNbt.loadNBTFiles(chunk.method_12004());
    }

    public static List<class_2960> loadNBTFiles(class_1923 chunk) {
        ArrayList<class_2960> nbtList = new ArrayList<class_2960>();
        String chunkFolderPath = class_2960.method_60655((String)"easierworldcreator", (String)("generated/structures/" + chunk.field_9181 + "_" + chunk.field_9180 + "/")).method_12832();
        try {
            Path path = Path.of(chunkFolderPath, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                Files.list(path).forEach(filePath -> {
                    if (filePath.toString().endsWith(".nbt")) {
                        nbtList.add(class_2960.method_60655((String)"easierworldcreator", (String)(chunk.field_9181 + "_" + chunk.field_9180 + "/" + filePath.getFileName().toString())));
                    }
                });
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return nbtList;
    }

    @Unique
    public static class_3499.class_5162 createPalettedBlockInfoList(List<class_3499.class_3501> combinedList) {
        return PalettedBlockInfoListMixin.invokeConstructor(combinedList);
    }
}

