/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.rodofire.easierworldcreator.blockdata.BlockDataKey;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.util.FastNoiseLite;
import org.jetbrains.annotations.Nullable;

public class BlockPlaceUtil {
    public static boolean place(class_5281 world, class_2338 pos, BlockDataKey data, @Nullable StructurePlacementRuleManager ruler, int flag) {
        class_2680 state = world.method_8320(pos);
        if (ruler != null && ruler.canPlace(state)) {
            return BlockPlaceUtil.setBlockState(world, pos, data, flag);
        }
        if (!state.method_26215()) {
            return false;
        }
        return BlockPlaceUtil.setBlockState(world, pos, data, flag);
    }

    private static boolean setBlockState(class_5281 world, class_2338 pos, BlockDataKey data, int flag) {
        boolean bl = world.method_8652(pos, data.getState(), flag);
        if (bl && data.getTag() != null) {
            class_2586 entity = world.method_8321(pos);
            if (entity != null) {
                class_5455 registry = world.method_30349();
                class_2487 currentNbt = entity.method_38242((class_7225.class_7874)registry);
                currentNbt.method_10543(data.getTag());
                entity.method_58690(currentNbt, (class_7225.class_7874)registry);
                entity.method_5431();
            }
            return true;
        }
        return bl;
    }

    public static boolean verifyBlock(class_5281 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26215();
    }

    public static boolean verifyBlock(class_5281 world, boolean force, Set<class_2248> blocksToForce, class_2338 pos) {
        class_2680 state2 = world.method_8320(pos);
        return BlockPlaceUtil.verify(world, force, blocksToForce, pos, state2);
    }

    public static boolean verifyBlock(class_5281 world, boolean force, Set<class_2248> blocksToForce, class_2338 pos, Map<class_2338, class_2680> blockStateMap) {
        class_2680 state = blockStateMap.get(pos);
        return BlockPlaceUtil.verify(world, force, blocksToForce, pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean verify(class_5281 world, boolean force, Set<class_2248> blocksToForce, class_2338 pos, class_2680 state) {
        if (state.method_26214((class_1922)world, pos) < 0.0f) {
            return false;
        }
        if (force) return true;
        if (blocksToForce == null) {
            blocksToForce = Set.of(class_2246.field_9987);
        }
        if (state.method_26215()) return true;
        if (!blocksToForce.stream().anyMatch(state.method_26204()::equals)) return false;
        return true;
    }

    public static void placeBlock(class_5281 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 3);
    }

    public static boolean placeVerifiedBlock(class_5281 world, boolean force, Set<class_2248> blocksToForce, class_2338 pos, class_2680 state) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeBlock(world, pos, state);
            return true;
        }
        return false;
    }

    public static boolean placeVerifiedBlock(class_5281 world, class_2338 pos, class_2680 state) {
        if (BlockPlaceUtil.verifyBlock(world, false, Set.of(), pos)) {
            BlockPlaceUtil.placeBlock(world, pos, state);
            return true;
        }
        return false;
    }

    public static void placeBlockWithNbt(class_5281 world, class_2338 pos, class_2680 state, class_2487 compound) {
        class_2586 entity;
        BlockPlaceUtil.placeBlock(world, pos, state);
        if (compound != null && (entity = world.method_8321(pos)) != null) {
            class_5455 registry = world.method_30349();
            class_2487 currentNbt = entity.method_38242((class_7225.class_7874)registry);
            currentNbt.method_10543(compound);
            entity.method_58690(currentNbt, (class_7225.class_7874)registry);
            entity.method_5431();
        }
    }

    public static boolean placeVerifiedBlockWithNbt(class_5281 world, boolean force, Set<class_2248> blocksToForce, class_2338 pos, class_2680 state, class_2487 compound) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeBlockWithNbt(world, pos, state, compound);
            return true;
        }
        return false;
    }

    public static boolean setBlockWithOrderWithVerification(class_5281 world, boolean force, Set<class_2248> blocksToForce, List<class_2680> blockToPlace, class_2338 pos, int i) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeBlockWithOrder(world, blockToPlace, pos, i);
            return true;
        }
        return false;
    }

    public static boolean setRandomBlockWithVerification(class_5281 world, boolean force, Set<class_2248> blocksToForce, List<class_2680> blockToPlace, class_2338 pos) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeRandomBlock(world, blockToPlace, pos);
            return true;
        }
        return false;
    }

    public static boolean set2dNoiseBlockWithVerification(class_5281 world, boolean force, Set<class_2248> blocksToForce, List<class_2680> blockToPlace, class_2338 pos, FastNoiseLite noise) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeBlockWith2DNoise(world, blockToPlace, pos, noise);
            return true;
        }
        return false;
    }

    public static boolean set3dNoiseBlockWithVerification(class_5281 world, boolean force, Set<class_2248> blocksToForce, List<class_2680> blockToPlace, class_2338 pos, FastNoiseLite noise) {
        if (BlockPlaceUtil.verifyBlock(world, force, blocksToForce, pos)) {
            BlockPlaceUtil.placeBlockWith3DNoise(world, blockToPlace, pos, noise);
            return true;
        }
        return false;
    }

    public static void placeRandomBlock(class_5281 world, List<class_2680> blockToPlace, class_2338 pos) {
        int length = blockToPlace.size() - 1;
        world.method_8652(pos, blockToPlace.get(class_5819.method_43047().method_39332(0, length)), 2);
    }

    public static void placeBlockWithOrder(class_5281 world, List<class_2680> blocksToPlace, class_2338 pos, int i) {
        world.method_8652(pos, blocksToPlace.get(i), 2);
    }

    public static void placeBlockWith2DNoise(class_5281 world, List<class_2680> blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        float a = noise.GetNoise(pos.method_10263(), pos.method_10260());
        BlockPlaceUtil.placeBlockWithNoise(world, blocksToPlace, pos, a);
    }

    public static void placeBlockWith3DNoise(class_5281 world, List<class_2680> blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        float a = noise.GetNoise(pos);
        BlockPlaceUtil.placeBlockWithNoise(world, blocksToPlace, pos, a);
    }

    private static void placeBlockWithNoise(class_5281 world, List<class_2680> blocksToPlace, class_2338 pos, float a) {
        int length = blocksToPlace.size() - 1;
        class_2680 state = blocksToPlace.get((int)((double)length * ((double)(a / 2.0f) + 0.5)));
        world.method_8652(pos, state, 3);
    }

    public static class_2680 getRandomBlock(List<class_2680> blocksToPlace) {
        return blocksToPlace.get(class_5819.method_43047().method_39332(0, blocksToPlace.size() - 1));
    }

    public static class_2680 getBlockWithOrder(List<class_2680> blocksToPlace, int i) {
        return blocksToPlace.get(i);
    }

    public static class_2680 getBlockWith2DNoise(List<class_2680> blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        double a = noise.GetNoise(pos.method_10263(), pos.method_10260());
        return BlockPlaceUtil.getBlockStateWithNoise(blocksToPlace, a);
    }

    public static class_2680 getBlockWith3DNoise(List<class_2680> blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        double a = noise.GetNoise(pos);
        return BlockPlaceUtil.getBlockStateWithNoise(blocksToPlace, a);
    }

    private static class_2680 getBlockStateWithNoise(List<class_2680> blocksToPlace, double a) {
        int size = blocksToPlace.size();
        int index = (int)Math.floor((a + 1.0) * (double)size / 2.0);
        index = Math.min(index, size - 1);
        return blocksToPlace.get(index);
    }

    public static class_2680 getRandomBlock(class_2680[] blocksToPlace) {
        return blocksToPlace[class_5819.method_43047().method_39332(0, blocksToPlace.length - 1)];
    }

    public static class_2680 getBlockWithOrder(class_2680[] blocksToPlace, int i) {
        return blocksToPlace[i];
    }

    public static class_2680 getBlockWith2DNoise(class_2680[] blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        double a = noise.GetNoise(pos.method_10263(), pos.method_10260());
        return BlockPlaceUtil.getBlockStateWithNoise(blocksToPlace, a);
    }

    public static class_2680 getBlockWith3DNoise(class_2680[] blocksToPlace, class_2338 pos, FastNoiseLite noise) {
        double a = noise.GetNoise(pos);
        return BlockPlaceUtil.getBlockStateWithNoise(blocksToPlace, a);
    }

    private static class_2680 getBlockStateWithNoise(class_2680[] blocksToPlace, double a) {
        int size = blocksToPlace.length;
        int index = (int)Math.floor((a + 1.0) * (double)size / 2.0);
        index = Math.min(index, size - 1);
        return blocksToPlace[index];
    }
}

