/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;

public class BlockStateUtil {
    static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors();

    public static class_2680 parseBlockState(class_5281 world, String stateString) {
        class_2960 identifier;
        class_7225 blockLookup = world.method_45448(class_7924.field_41254);
        Optional optional = blockLookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)(identifier = class_2960.method_60654((String)BlockStateUtil.extractBlockName(stateString.split("\\[")[0])))));
        if (optional.isEmpty()) {
            Ewc.LOGGER.error("error parsing BlockState: {}", (Object)stateString.split("\\[")[0]);
            return class_2246.field_10124.method_9564();
        }
        class_2248 block = (class_2248)((class_6880)optional.get()).comp_349();
        class_2680 blockState = block.method_9564();
        if (stateString.contains("[")) {
            String propertiesPart = stateString.split("\\[")[1].replace("]", "");
            String[] keyValuePairs = propertiesPart.split(",");
            class_2689 stateManager = block.method_9595();
            for (String pair : keyValuePairs) {
                String[] keyValue = pair.split("=");
                class_2769 property = stateManager.method_11663(keyValue[0]);
                if (property == null) continue;
                blockState = BlockStateUtil.applyProperty(blockState, property, keyValue[1]);
            }
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 applyProperty(class_2680 state, class_2769<T> property, String value) {
        Comparable propertyValue = (Comparable)property.method_11900(value).orElseThrow(() -> new IllegalArgumentException("Invalid property value"));
        return (class_2680)state.method_11657(property, propertyValue);
    }

    private static String extractBlockName(String blockString) {
        if (blockString.startsWith("Block{") && blockString.endsWith("}")) {
            return blockString.substring(6, blockString.length() - 1);
        }
        throw new IllegalArgumentException("Invalid block string format: " + blockString);
    }

    public static void getBlockStatesFromWorld(List<Set<class_2338>> posList, Map<class_2338, class_2680> blockStateMap, class_5281 world) {
        ConcurrentHashMap concurrentMap = new ConcurrentHashMap();
        ExecutorService executorService = Executors.newFixedThreadPool(THREAD_COUNT);
        for (Set<class_2338> set : posList) {
            for (class_2338 blockPos : set) {
                blockStateMap.put(blockPos, world.method_8320(blockPos));
            }
        }
        executorService.shutdown();
    }

    public static BlockListManager getCompoundBlockStatesFromWorld(List<Set<class_2338>> posList, class_5281 world) {
        BlockListManager comparator = new BlockListManager();
        for (Set<class_2338> set : posList) {
            for (class_2338 blockPos : set) {
                class_2680 blockState = world.method_8320(blockPos);
                class_2586 entity = world.method_8321(blockPos);
                if (entity != null) {
                    class_5455 registry = world.method_30349();
                    class_2487 nbtCompound = entity.method_38242((class_7225.class_7874)registry);
                    comparator.put(blockState, nbtCompound, blockPos);
                    continue;
                }
                comparator.put(blockState, null, blockPos);
            }
        }
        return comparator;
    }

    public static OrderedBlockListManager getBlockStatesFromWorld(List<Set<class_2338>> posList, class_5281 world) {
        OrderedBlockListManager comparator = new OrderedBlockListManager();
        for (Set<class_2338> set : posList) {
            for (class_2338 blockPos : set) {
                class_2680 blockState = world.method_8320(blockPos);
                comparator.put(blockState, blockPos);
            }
        }
        return comparator;
    }
}

