/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.maths.MathUtil;

public class WorldGenUtil {
    public static class_2350 getRandomDirection() {
        return switch (class_5819.method_43047().method_39332(0, 5)) {
            case 0 -> class_2350.field_11039;
            case 1 -> class_2350.field_11034;
            case 2 -> class_2350.field_11043;
            case 3 -> class_2350.field_11035;
            case 4 -> class_2350.field_11036;
            default -> class_2350.field_11033;
        };
    }

    public static class_2350 getRandomVerticalDirection() {
        return class_5819.method_43047().method_39332(0, 1) == 1 ? class_2350.field_11036 : class_2350.field_11033;
    }

    public static class_2350 getRandomHorizontalDirection() {
        return switch (class_5819.method_43047().method_39332(0, 3)) {
            case 0 -> class_2350.field_11039;
            case 1 -> class_2350.field_11034;
            case 2 -> class_2350.field_11043;
            default -> class_2350.field_11035;
        };
    }

    public static int getSecondHeight(float chance, int maxHeight) {
        return WorldGenUtil.getSecondHeight(chance, 0, maxHeight);
    }

    public static int getSecondHeight(float chance, int minHeight, int maxHeight) {
        if (class_5819.method_43047().method_43057() < chance) {
            return class_5819.method_43047().method_39332(minHeight, maxHeight);
        }
        return 0;
    }

    public static boolean isBlockInBlockStateList(class_2248 block, List<class_2680> state) {
        for (class_2680 blockState : state) {
            if (!blockState.method_26204().equals(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockStateInBlockStateList(class_2680 block, List<class_2680> state) {
        for (class_2680 blockState : state) {
            if (blockState != block) continue;
            return true;
        }
        return false;
    }

    public static double getAbs(class_243 pos) {
        return MathUtil.absDistance(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static double getSquared(class_243 pos) {
        return MathUtil.squared(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static float getDistance(class_2338 pos1, class_2338 pos2) {
        return FastMaths.getLength(pos1.method_10263() - pos2.method_10263(), pos1.method_10264() - pos2.method_10264(), pos1.method_10260() - pos2.method_10260());
    }

    public static float getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return FastMaths.getLength(x1 - x2, y1 - y2, z1 - z2);
    }

    public static float getDistance(int x1, int y1, int z1, int[] pos2) {
        return FastMaths.getLength(x1 - pos2[0], y1 - pos2[1], z1 - pos2[2]);
    }

    public static float getDistance(int[] pos1, int[] pos2) {
        return FastMaths.getLength(pos1[0] - pos2[0], pos1[1] - pos2[1], pos1[2] - pos2[2]);
    }

    public static float getDistance(class_2338 pos1, class_2338 pos2, float precision) {
        return FastMaths.getLengthWPrecision(pos1.method_10263() - pos2.method_10263(), pos1.method_10264() - pos2.method_10264(), pos1.method_10260() - pos2.method_10260(), precision);
    }

    public static float getDistance(class_243 pos1, class_243 pos2) {
        return FastMaths.getLength((float)(pos1.method_10216() - pos2.method_10216()), (float)(pos1.method_10214() - pos2.method_10214()), (float)(pos1.method_10215() - pos2.method_10215()));
    }

    public static float getDistance(class_243 pos1, class_243 pos2, float precision) {
        return FastMaths.getLengthWPrecision((float)(pos1.method_10216() - pos2.method_10216()), (float)(pos1.method_10214() - pos2.method_10214()), (float)(pos1.method_10215() - pos2.method_10215()), precision);
    }

    public static boolean isPosAChunkFar(class_2338 pos1, class_2338 pos2) {
        if (Math.abs(pos1.method_10263() - pos2.method_10263()) > 16) {
            return true;
        }
        return Math.abs(pos1.method_10260() - pos2.method_10260()) > 16;
    }

    public static Set<class_2248> addBlockStateListToBlockList(Set<class_2248> block, List<class_2680> state) {
        ArrayList<class_2248> secondlist = new ArrayList<class_2248>();
        if (block == null) {
            block = new HashSet<class_2248>();
        }
        for (class_2680 blockState : state) {
            secondlist.add(blockState.method_26204());
        }
        block.addAll(secondlist);
        return block;
    }

    public static double getDistanceFromPointToPlane(class_243 normal, class_243 pointOnPlane, class_243 point) {
        double A = normal.field_1352;
        double B = normal.field_1351;
        double C = normal.field_1350;
        double D = -(A * pointOnPlane.field_1352 + B * pointOnPlane.field_1351 + C * pointOnPlane.field_1350);
        double x0 = point.field_1352;
        double y0 = point.field_1351;
        double z0 = point.field_1350;
        double numerator = Math.abs(A * x0 + B * y0 + C * z0 + D);
        double denominator = Math.sqrt(A * A + B * B + C * C);
        return numerator / denominator;
    }

    public static int getTotalBlockLayerDepth(List<BlockLayer> layers) {
        int i = 0;
        for (BlockLayer blockLayer : layers) {
            i += blockLayer.getDepth();
        }
        return i;
    }

    public static int getBlockLayerDepth(List<BlockLayer> layers, int index) {
        int i = 0;
        if (index >= layers.size()) {
            Ewc.LOGGER.error("int index >= blockLayer size");
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + layers.size());
        }
        for (int a = 0; a <= index; ++a) {
            i += layers.get(a).getDepth();
        }
        return i;
    }

    public static int getBlockLayerDepth(List<BlockLayer> layers, int startIndex, int endIndex) {
        int i = 0;
        if (startIndex >= layers.size()) {
            Ewc.LOGGER.error("int startIndex >= blockLayer size");
            throw new IndexOutOfBoundsException("Index: " + startIndex + ", Size: " + layers.size());
        }
        if (endIndex >= layers.size()) {
            Ewc.LOGGER.error("int endIndex >= blockLayer size");
            throw new IndexOutOfBoundsException("Index: " + endIndex + ", Size: " + layers.size());
        }
        if (endIndex < startIndex) {
            Ewc.LOGGER.error("int firstIndex > endIndex");
            return 0;
        }
        for (int a = startIndex; a <= endIndex; ++a) {
            i += layers.get(a).getDepth();
        }
        return i;
    }

    public static class_2350 getDirection(class_2338 pos1, class_2338 pos2) {
        if (pos1.method_10263() == pos2.method_10263() && pos1.method_10264() == pos2.method_10264()) {
            return pos2.method_10260() - pos1.method_10260() < 0 ? class_2350.field_11039 : class_2350.field_11034;
        }
        if (pos1.method_10263() == pos2.method_10263() && pos1.method_10260() == pos2.method_10260()) {
            return pos2.method_10264() - pos1.method_10264() < 0 ? class_2350.field_11033 : class_2350.field_11036;
        }
        if (pos1.method_10264() == pos2.method_10264() && pos1.method_10260() == pos2.method_10260()) {
            return pos2.method_10263() - pos1.method_10263() < 0 ? class_2350.field_11035 : class_2350.field_11043;
        }
        return null;
    }

    public static class_1923 addChunkPos(class_1923 pos1, class_1923 pos2) {
        return new class_1923(pos1.field_9181 + pos2.field_9181, pos1.field_9180 + pos2.field_9180);
    }

    public static class_1923 addChunkPos(class_1923 pos1, int x, int z) {
        return new class_1923(pos1.field_9181 + x, pos1.field_9180 + z);
    }

    public static class_1923 addChunkPos(class_1923 pos1, class_2338 pos2) {
        class_1923 pos = new class_1923(pos2);
        return new class_1923(pos1.field_9181 + pos.field_9181, pos1.field_9180 + pos.field_9180);
    }

    public static float getDistanceToAxis(class_243 centerPos, class_243 axisDir, class_243 pos) {
        class_243 v = pos.method_1020(centerPos);
        class_243 cross = v.method_1036(axisDir);
        double crossNorm = cross.method_1033();
        double dirNorm = axisDir.method_1033();
        return (float)(crossNorm / dirNorm);
    }

    public static double getExactDistance(class_243 pos) {
        return MathUtil.getExactDistance(pos.field_1352, pos.field_1351, pos.field_1350);
    }
}

