/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util.file;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.rodofire.easierworldcreator.Ewc;

public class EwcFolderData {
    private static final Map<class_5321<class_1937>, Path> dimensionPath = new HashMap<class_5321<class_1937>, Path>();

    public static void initFiles() {
        Ewc.LOGGER.info("|\t- Registering Data Folders");
        ServerWorldEvents.LOAD.register((minecraftServer, serverWorld) -> {
            dimensionPath.put((class_5321<class_1937>)serverWorld.method_27983(), class_2874.method_12488((class_5321)serverWorld.method_27983(), (Path)minecraftServer.method_27050(class_5218.field_24188)));
            EwcFolderData.createDirectories(serverWorld);
        });
    }

    private static void createDirectories(class_3218 world) {
        File file = EwcFolderData.getEwcDataDirectory(world).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = EwcFolderData.getStructuresDirectory(world).toFile()).exists()) {
            file.mkdirs();
        }
        if (!(file = EwcFolderData.getReferenceDir(world).toFile()).exists()) {
            file.mkdirs();
        }
    }

    public static Path getEwcDataDirectory(class_5281 world) {
        class_3218 serverWorld = world.method_8410();
        return dimensionPath.get(serverWorld.method_27983()).resolve("ewc_data");
    }

    public static Path getStructuresDirectory(class_5281 world) {
        Path path = EwcFolderData.getEwcDataDirectory(world);
        return path.resolve("structures");
    }

    public static Path getStructureDataDir(class_5281 world, class_1923 chunk) {
        Path path = EwcFolderData.getStructuresDirectory(world);
        return path.resolve("chunk_" + chunk.field_9181 + "_" + chunk.field_9180);
    }

    public static Path getNVerifyDataDir(class_5281 world, class_1923 chunk) {
        Path path = EwcFolderData.getStructureDataDir(world, chunk);
        if (path.toFile().exists()) {
            return path;
        }
        path.toFile().mkdirs();
        return path;
    }

    public static Path getReferenceDir(class_5281 world) {
        Path path = EwcFolderData.getEwcDataDirectory(world);
        return path.resolve("structure_references");
    }

    public static Path getStructureReference(class_5281 world, class_1923 chunk) {
        Path path = EwcFolderData.getReferenceDir(world);
        return path.resolve("chunk_" + chunk.field_9181 + "_" + chunk.field_9180 + ".json");
    }

    public static Path getEwcDataDirectory(class_3218 world) {
        return dimensionPath.get(world.method_27983()).resolve("ewc_data");
    }

    public static Path getStructuresDirectory(class_3218 world) {
        Path path = EwcFolderData.getEwcDataDirectory(world);
        return path.resolve("structures");
    }

    public static Path getStructureDataDir(class_3218 world, class_1923 chunk) {
        Path path = EwcFolderData.getStructuresDirectory(world);
        return path.resolve("chunk_" + chunk.field_9181 + "_" + chunk.field_9180);
    }

    public static Path getNVerifyDataDir(class_3218 world, class_1923 chunk) {
        Path path = EwcFolderData.getStructureDataDir(world, chunk);
        if (path.toFile().exists()) {
            return path;
        }
        path.toFile().mkdirs();
        return path;
    }

    public static Path getReferenceDir(class_3218 world) {
        Path path = EwcFolderData.getEwcDataDirectory(world);
        return path.resolve("structure_references");
    }

    public static Path getStructureReference(class_3218 world, class_1923 chunk) {
        Path path = EwcFolderData.getReferenceDir(world);
        return path.resolve("chunk_" + chunk.field_9181 + "_" + chunk.field_9180 + ".json");
    }

    public static class Legacy {
        public static Path getLegacyGeneratedChunkDir(class_2791 chunk, class_5281 world) {
            Path generatedPath = Objects.requireNonNull(world.method_8503()).method_27050(class_5218.field_24185).normalize();
            String chunkDirPrefix = "chunk_" + chunk.method_12004().field_9181 + "_" + chunk.method_12004().field_9180;
            return generatedPath.resolve("easierworldcreator").resolve("structures").resolve(chunkDirPrefix);
        }

        public static Path getLegacyStructureDir(class_5281 world) {
            Path generatedPath = Objects.requireNonNull(world.method_8503()).method_27050(class_5218.field_24185).normalize();
            return generatedPath.resolve("easierworldcreator").resolve("structures");
        }
    }
}

