/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.class_2791;
import net.minecraft.class_5218;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.Ewc;

public class FileUtil {
    public static void renameFile(Path oldPath, Path newPath) {
        if (Files.exists(oldPath, new LinkOption[0])) {
            try {
                Path parentDir = newPath.getParent();
                if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                Files.move(oldPath, newPath, new CopyOption[0]);
            }
            catch (IOException e) {
                Ewc.LOGGER.warn("Failed to rename file. oldPath: {} newPath: {}", new Object[]{oldPath, newPath, e});
            }
            catch (SecurityException e) {
                Ewc.LOGGER.warn("Insufficient permissions to rename file. oldPath: {} newPath: {}", new Object[]{oldPath, newPath, e});
            }
        } else {
            Ewc.LOGGER.warn("Renaming file failed, file doesn't exist: {}", (Object)oldPath);
        }
    }

    public static void removeFile(Path path) {
        File file = new File(path.toString());
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    public static Path getLegacyGeneratedChunkDir(class_2791 chunk, class_5281 world) {
        Path generatedPath = Objects.requireNonNull(world.method_8503()).method_27050(class_5218.field_24185).normalize();
        String chunkDirPrefix = "chunk_" + chunk.method_12004().field_9181 + "_" + chunk.method_12004().field_9180;
        return generatedPath.resolve("easierworldcreator").resolve("structures").resolve(chunkDirPrefix);
    }

    public static void removeGeneratedChunkDirectory(class_2791 chunk, class_5281 world) {
        Path directoryPath = FileUtil.getLegacyGeneratedChunkDir(chunk, world);
        File file = new File(directoryPath.toString());
        if (file.exists() && file.isDirectory()) {
            boolean bl = file.delete();
        }
    }

    public static Path getWorldSavePathDirectory(class_5281 world, class_5218 savePath) {
        return Objects.requireNonNull(world.method_8503()).method_27050(savePath).normalize();
    }

    public static String loadJson(Path path) {
        String jsonContent;
        try {
            jsonContent = Files.readString(path);
        }
        catch (IOException e) {
            e.fillInStackTrace();
            return null;
        }
        return jsonContent;
    }
}

