/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.config.ewc.EwcConfig;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;

public class LoadChunkShapeInfo {
    public static List<Path> getWorldGenFiles(class_5281 worldAccess, class_2338 pos) {
        return LoadChunkShapeInfo.getWorldGenFiles(worldAccess, new class_1923(pos));
    }

    public static List<Path> getWorldGenFiles(class_5281 worldAccess, class_1923 chunk) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        int distance = EwcConfig.getFeaturesChunkDistance();
        Path generatedPath = EwcFolderData.getStructureDataDir(worldAccess, chunk);
        if (generatedPath == null) {
            return new ArrayList<Path>();
        }
        if (Files.exists(generatedPath = generatedPath.resolve("easierworldcreator").resolve("structures"), new LinkOption[0]) && Files.isDirectory(generatedPath, new LinkOption[0])) {
            for (int i = -distance; i <= distance; ++i) {
                for (int j = -distance; j <= distance; ++j) {
                    int chunkX = chunk.field_9181 + i;
                    int chunkZ = chunk.field_9180 + j;
                    String chunkDirPrefix = "chunk_" + chunkX + "_" + chunkZ;
                    Path newPath = generatedPath.resolve(chunkDirPrefix);
                    LoadChunkShapeInfo.getPathFromChunk(newPath, pathList);
                }
            }
        }
        return pathList;
    }

    private static void getPathFromChunk(Path generatedPath, List<Path> pathList) {
        try (Stream<Path> paths = Files.list(generatedPath);){
            paths.forEach(filePath -> {
                if (filePath.toString().endsWith(".json")) {
                    pathList.add((Path)filePath);
                }
            });
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }
}

