/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util.map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class ObjectIntLinkHashBiMap<T> {
    private List<T> object = new ArrayList<T>();
    private Object2IntMap<T> map = new Object2IntOpenHashMap();

    public ObjectIntLinkHashBiMap() {
    }

    public ObjectIntLinkHashBiMap(int capacity) {
        this.object = new ArrayList<T>(capacity);
        this.map = new Object2IntOpenHashMap(capacity);
    }

    public ObjectIntLinkHashBiMap(List<T> objects) {
        this.object = new ArrayList<T>(objects.size());
        int size = 0;
        for (T t : objects) {
            this.object.add(t);
            this.map.put(t, size++);
        }
    }

    public T get(short index) {
        return this.object.get(index);
    }

    public int get(T object) {
        return this.map.getInt(object);
    }

    public boolean contains(T object) {
        return this.map.containsKey(object);
    }

    public int size() {
        return this.object.size();
    }

    public T put(T object) {
        this.map.put(object, (int)((short)this.size()));
        this.object.add(object);
        return object;
    }

    public void putAll(List<T> objects) {
        this.object.addAll(objects);
        for (T t : objects) {
            this.map.put(t, this.size());
        }
    }

    public T remove(short index) {
        T removed = this.object.remove(index);
        this.map.removeInt(removed);
        return removed;
    }

    public T remove(T object) {
        int index = this.map.removeInt(object);
        return this.object.remove(index);
    }
}

