/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.util.map;

import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class ObjectShortLinkHashBiMap<T> {
    private List<T> object = new ArrayList<T>();
    private Object2ShortOpenHashMap<T> map = new Object2ShortOpenHashMap();

    public ObjectShortLinkHashBiMap() {
    }

    public ObjectShortLinkHashBiMap(int capacity) {
        this.object = new ArrayList<T>(capacity);
        this.map = new Object2ShortOpenHashMap(capacity);
    }

    public ObjectShortLinkHashBiMap(List<T> objects) {
        this.object = new ArrayList<T>(objects.size());
        short size = 0;
        for (T t : objects) {
            this.object.add(t);
            short s = size;
            size = (short)(size + 1);
            this.map.put(t, s);
        }
    }

    public T get(short index) {
        return this.object.get(index);
    }

    public short get(T object) {
        return this.map.getShort(object);
    }

    public boolean contains(T object) {
        return this.map.containsKey(object);
    }

    public short size() {
        return (short)this.object.size();
    }

    public short put(T object) {
        if (this.map.containsKey(object)) {
            return this.map.getShort(object);
        }
        short size = this.size();
        this.map.put(object, size);
        this.object.add(object);
        return size;
    }

    public void putAll(List<T> objects) {
        this.object.addAll(objects);
        for (T t : objects) {
            if (this.map.containsKey(t)) continue;
            this.map.put(t, this.size());
        }
    }

    public T remove(short index) {
        T removed = this.object.remove(index);
        this.map.removeShort(removed);
        return removed;
    }

    public T remove(T object) {
        short index = this.map.removeShort(object);
        return this.object.remove(index);
    }
}

