/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.world.chunk;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.config.ewc.EwcConfig;
import net.rodofire.easierworldcreator.util.ChunkUtil;
import org.jetbrains.annotations.NotNull;

public class ChunkPosManager {
    private final Map<class_1923, ChunkState> chunkStateMap = new ConcurrentHashMap<class_1923, ChunkState>();
    private class_1923 offset = new class_1923(0, 0);
    @NotNull
    private final class_5281 world;

    public ChunkPosManager(@NotNull class_5281 world) {
        this.world = world;
    }

    public ChunkPosManager(@NotNull class_5281 world, Set<class_1923> toTest) {
        this.world = world;
        this.putAll(toTest);
    }

    public ChunkPosManager(@NotNull class_5281 world, class_1923 toTest) {
        this.world = world;
        this.put(toTest);
    }

    public boolean put(class_1923 chunkPos) {
        ChunkState state = this.chunkStateMap.get(chunkPos);
        if (state != null) {
            return state != ChunkState.UNALLOWED;
        }
        if (!ChunkUtil.isFeaturesGenerated((class_4538)this.world, chunkPos)) {
            this.chunkStateMap.put(chunkPos, ChunkState.UNGENERATED);
            return true;
        }
        if (this.canBeAllowed(chunkPos)) {
            this.chunkStateMap.put(chunkPos, ChunkState.ALLOWED);
            return true;
        }
        this.chunkStateMap.put(chunkPos, ChunkState.UNALLOWED);
        return false;
    }

    private boolean putSafe(class_1923 chunkPos) {
        if (!ChunkUtil.isFeaturesGenerated((class_4538)this.world, chunkPos)) {
            this.chunkStateMap.put(chunkPos, ChunkState.UNGENERATED);
            return true;
        }
        return false;
    }

    private boolean canBeAllowed(class_1923 chunkPos) {
        int distance = EwcConfig.getFeaturesChunkDistance();
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                if (z == 0 && x == 0) continue;
                class_1923 pos = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
                ChunkState state = this.chunkStateMap.get(pos);
                if (state == ChunkState.UNGENERATED) {
                    return true;
                }
                if (state != null || !this.putSafe(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public void putAll(Set<class_1923> chunks) {
        chunks.forEach(this::put);
    }

    public boolean containsChunk(class_1923 chunkPos) {
        return this.chunkStateMap.containsKey(chunkPos);
    }

    public boolean isMultiChunk(Set<class_1923> posSetMap, class_2338 centerPos) {
        if ((double)posSetMap.size() > Math.pow(2 * EwcConfig.getFeaturesChunkDistance() + 1, 2.0)) {
            return true;
        }
        for (class_1923 set : posSetMap) {
            if (Math.abs(set.field_9181) > EwcConfig.getFeaturesChunkDistance() + Math.abs(new class_1923((class_2338)centerPos).field_9181)) {
                return true;
            }
            if (Math.abs(set.field_9180) <= EwcConfig.getFeaturesChunkDistance() + Math.abs(new class_1923((class_2338)centerPos).field_9180)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceMultiChunk(Set<class_1923> chunkPosSet, int maxDistance) {
        int minOffset = Integer.MAX_VALUE;
        for (int distance = 0; distance <= maxDistance; ++distance) {
            for (int x = -distance; x <= distance; ++x) {
                for (int z = -distance; z <= distance; ++z) {
                    if (Math.abs(x) < distance && Math.abs(z) < distance || !this.canGenerate(chunkPosSet, x, z)) continue;
                    this.offset = new class_1923(x, z);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canGenerate(Set<class_1923> chunkPosSet, int x, int z) {
        return chunkPosSet.parallelStream().noneMatch(chunkPos -> {
            chunkPos = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
            ChunkState existingState = this.chunkStateMap.get(chunkPos);
            if (existingState != null) {
                return existingState == ChunkState.UNALLOWED;
            }
            ChunkState newState = !ChunkUtil.isFeaturesGenerated((class_4538)this.world, chunkPos) ? ChunkState.UNGENERATED : (this.canBeAllowed((class_1923)chunkPos) ? ChunkState.ALLOWED : ChunkState.UNALLOWED);
            this.chunkStateMap.put((class_1923)chunkPos, newState);
            return newState == ChunkState.UNALLOWED;
        });
    }

    public class_1923 getOffset() {
        return this.offset;
    }

    private static enum ChunkState {
        UNGENERATED,
        ALLOWED,
        UNALLOWED;

    }
}

