/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.atlatl;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Atlatl {
    public static final String MOD_ID = "atlatl";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"atlatl");
    public static Item ATLATL;

    public static Item makeAtlatl() {
        return new ProjectileWeaponItem(new Item.Properties().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).durability(216)){

            public Predicate<ItemStack> getAllSupportedProjectiles() {
                return ARROW_ONLY;
            }

            public int getDefaultProjectileRange() {
                return 4;
            }

            public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
                ItemStack itemStack = user.getItemInHand(hand);
                ItemStack ammo = user.getProjectile(itemStack);
                if (!user.hasInfiniteMaterials() && ammo.isEmpty()) {
                    return InteractionResultHolder.fail((Object)itemStack);
                }
                boolean crit = false;
                if (user.isSprinting()) {
                    user.causeFoodExhaustion(10.0f);
                    user.setSprinting(false);
                    crit = true;
                } else {
                    user.causeFoodExhaustion(1.0f);
                }
                List list = 1.draw((ItemStack)itemStack, (ItemStack)ammo, (LivingEntity)user);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (!list.isEmpty()) {
                        this.shoot(serverWorld, (LivingEntity)user, hand, itemStack, list, user.getAttackStrengthScale(0.0f) + 0.5f, 1.0f - user.getAttackStrengthScale(0.0f), crit, null);
                        user.swing(hand, true);
                    }
                }
                if (user instanceof ServerPlayer) {
                    ServerPlayer s = (ServerPlayer)user;
                    s.swing(hand);
                } else {
                    user.resetAttackStrengthTicker();
                }
                user.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.consume((Object)itemStack);
            }

            protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float speed, float divergence, float yaw, @Nullable LivingEntity target) {
                projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + yaw, 0.0f, speed, divergence);
            }
        };
    }

    public static void init() {
        LOGGER.info("Atlatl-ing time!");
    }
}

