/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.atlatl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Atlatl {
    public static final String MOD_ID = "atlatl";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"atlatl");
    public static Item ATLATL;

    public static Item makeAtlatl() {
        return new ProjectileWeaponItem(new Item.Properties().m_41503_(216)){
            private final Multimap<Attribute, AttributeModifier> attributeModifiers = this.buildStats();

            private Multimap<Attribute, AttributeModifier> buildStats() {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.5, AttributeModifier.Operation.ADDITION));
                return builder.build();
            }

            public Predicate<ItemStack> m_6437_() {
                return f_43005_;
            }

            public int m_6615_() {
                return 4;
            }

            public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
                boolean infiniteArrows;
                boolean infinity;
                ItemStack itemStack = user.m_21120_(hand);
                ItemStack ammo = user.m_6298_(itemStack);
                boolean bl = infinity = user.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0;
                if (infinity && ammo.m_41619_()) {
                    ammo = Items.f_42412_.m_7968_();
                }
                if (!user.m_7500_() && ammo.m_41619_()) {
                    return InteractionResultHolder.m_19100_((Object)itemStack);
                }
                boolean crit = false;
                if (user.m_20142_()) {
                    user.m_36399_(10.0f);
                    user.m_6858_(false);
                    crit = true;
                } else {
                    user.m_36399_(1.0f);
                }
                boolean bl2 = infiniteArrows = infinity && itemStack.m_150930_(Items.f_42412_);
                if (!world.f_46443_) {
                    int k;
                    ArrowItem arrowItem = (ArrowItem)(itemStack.m_41720_() instanceof ArrowItem ? itemStack.m_41720_() : Items.f_42412_);
                    AbstractArrow persistentProjectileEntity = arrowItem.m_6394_(world, itemStack, (LivingEntity)user);
                    persistentProjectileEntity.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, user.m_36403_(0.0f) + 0.5f, 1.0f - user.m_36403_(0.0f));
                    persistentProjectileEntity.m_36762_(crit);
                    int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemStack);
                    if (j > 0) {
                        persistentProjectileEntity.m_36781_(persistentProjectileEntity.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemStack)) > 0) {
                        persistentProjectileEntity.m_36735_(k);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemStack) > 0) {
                        persistentProjectileEntity.m_20254_(100);
                    }
                    itemStack.m_41622_(1, (LivingEntity)user, p -> p.m_21190_(hand));
                    if (infiniteArrows || user.m_150110_().f_35937_ && (itemStack.m_150930_(Items.f_42737_) || itemStack.m_150930_(Items.f_42738_))) {
                        persistentProjectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_((Entity)persistentProjectileEntity);
                    user.m_21011_(hand, true);
                }
                if (user instanceof ServerPlayer) {
                    ServerPlayer s = (ServerPlayer)user;
                    s.m_6674_(hand);
                } else {
                    user.m_36334_();
                }
                if (!infiniteArrows && !user.m_150110_().f_35937_) {
                    ammo.m_41774_(1);
                    if (itemStack.m_41619_()) {
                        user.m_150109_().m_36057_(ammo);
                    }
                }
                user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }

            public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
                return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
            }
        };
    }

    public static void init() {
        LOGGER.info("Atlatl-ing time!");
    }
}

