/*
 * Decompiled with CFR 0.152.
 */
package dev.funasitien.defaultserver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Singleton
public class Config {
    private static final String CONFIG_FILE_NAME = "config.yml";
    private final Path dataDirectory;
    private final Logger logger;
    private Map<String, Object> configuration;
    private List<String> allowedServers;

    @Inject
    public Config(@DataDirectory Path dataDirectory, Logger logger) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.loadConfig();
    }

    private void loadConfig() {
        Path configPath = this.dataDirectory.resolve(CONFIG_FILE_NAME);
        if (Files.notExists(configPath, new LinkOption[0])) {
            this.createDefaultConfig(configPath);
        }
        try (InputStream inputStream = Files.newInputStream(configPath, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            this.configuration = (Map)yaml.load(inputStream);
            this.allowedServers = this.configuration.getOrDefault("allowed-servers", List.of());
        }
        catch (IOException e) {
            this.logger.error("Error loading configuration file: {}", (Object)configPath, (Object)e);
            this.configuration = Map.of();
            this.allowedServers = List.of();
        }
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    private void createDefaultConfig(Path configPath) {
        try (InputStream defaultConfig = this.getClass().getResourceAsStream("/config.yml");){
            if (defaultConfig == null) {
                this.logger.error("Default configuration file not found: {}", (Object)CONFIG_FILE_NAME);
                return;
            }
            Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            Files.copy(defaultConfig, configPath, new CopyOption[0]);
            this.logger.info("Created default configuration file: {}", (Object)configPath);
        }
        catch (IOException e) {
            this.logger.error("Error creating default configuration file: {}", (Object)configPath, (Object)e);
        }
    }

    public Object getProperty(String key) {
        return this.configuration.get(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        return this.configuration.getOrDefault(key, defaultValue);
    }

    public List<String> getAllowedServers() {
        return this.allowedServers;
    }
}

