/*
 * Decompiled with CFR 0.152.
 */
package dev.funasitien.defaultserver;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import dev.funasitien.defaultserver.Config;
import dev.funasitien.defaultserver.DefaultServerManager;
import java.nio.file.Path;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

@Plugin(id="defaultserver", name="DefaultServer", version="1.0.0", authors={"Funasitien"}, url="https://f.dreamclouds.fr")
public class DefaultServer {
    private final ProxyServer proxyServer;
    private final Logger logger;
    private final Path dataDirectory;
    private final DefaultServerManager defaultServerManager;
    private final Config config;

    @Inject
    public DefaultServer(ProxyServer proxyServer, Logger logger, @DataDirectory Path dataDirectory, Config config) {
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.config = config;
        this.defaultServerManager = new DefaultServerManager(proxyServer, logger, dataDirectory);
        logger.info("DefaultServer plugin has been enabled!");
        logger.info("Allowed servers: {}", config.getAllowedServers());
        CommandManager commandManager = proxyServer.getCommandManager();
        commandManager.register("defaultserver", (Command)new DefaultServerCommand(), new String[]{"defaultserver"});
        commandManager.register("reloadserver", (Command)new DefaultServerReload(), new String[]{"reloadserver"});
    }

    @Subscribe
    public void onPlayerChooseInitialServer(PlayerChooseInitialServerEvent event) {
        Player player = event.getPlayer();
        String defaultServer = this.defaultServerManager.getDefaultServer(player.getUniqueId());
        if (defaultServer != null) {
            event.setInitialServer((RegisteredServer)this.proxyServer.getServer(defaultServer).orElse(null));
        }
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        Player player = event.getPlayer();
        String defaultServer = this.defaultServerManager.getDefaultServer(player.getUniqueId());
        if (defaultServer != null) {
            player.createConnectionRequest((RegisteredServer)this.proxyServer.getServer(defaultServer).orElse(null)).fireAndForget();
        }
    }

    private class DefaultServerCommand
    implements SimpleCommand {
        private DefaultServerCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            if (source instanceof Player) {
                Player player = (Player)source;
                if (((String[])invocation.arguments()).length == 1) {
                    String newDefaultServer = ((String[])invocation.arguments())[0];
                    if (DefaultServer.this.config.getAllowedServers().contains(newDefaultServer)) {
                        DefaultServer.this.defaultServerManager.setDefaultServer(player.getUniqueId(), newDefaultServer);
                        player.sendMessage((Component)Component.text((String)("Your default server has been set to " + newDefaultServer)));
                    } else {
                        player.sendMessage((Component)Component.text((String)("The server '" + newDefaultServer + "' is not allowed.")));
                    }
                } else {
                    player.sendMessage((Component)Component.text((String)"Usage: /defaultserver <server>"));
                }
            } else {
                invocation.source().sendMessage((Component)Component.text((String)"This command can only be used by players."));
            }
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            return DefaultServer.this.config.getAllowedServers();
        }

        public boolean hasPermission(SimpleCommand.Invocation invocation) {
            return true;
        }
    }

    private class DefaultServerReload
    implements SimpleCommand {
        private DefaultServerReload() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            DefaultServer.this.config.reloadConfig();
        }

        public boolean hasPermission(SimpleCommand.Invocation invocation) {
            return true;
        }
    }
}

