/*
 * Decompiled with CFR 0.152.
 */
package com.lumi.lots;

import com.lumi.lots.blocks.BlockBuilder;
import com.lumi.lots.blocks.BlockDropsHandler;
import com.lumi.lots.blocks.BlockTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="lumis_lots", version="@VERSION@")
public class LumisCore {
    public static final String MOD_ID = "lumis_lots";
    public static final String MOD_VERSION = "@VERSION@";
    @Mod.Instance(value="lumis_lots")
    public static LumisCore INSTANCE;
    public static Block testBlock;
    public static Block trueBlock;
    public static Block falseBlock;
    public static Block compostingDirt;
    public static Block compostedDirt;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("Lumi says \"Hello Forge world!\"");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Item[] compostableItems;
        Block[] compostableBlocks;
        testBlock = new BlockBuilder().setName("Test Block").setMaterial(7).setSound(1).setTab(0).build();
        trueBlock = new BlockBuilder().setName("True Block").setMaterial(7).setSound(1).setTab(0).build();
        falseBlock = new BlockBuilder().setName("False Block").setMaterial(7).setSound(1).setTab(0).build();
        compostingDirt = new BlockBuilder().setName("Composting Dirt").setMaterial(15).setSound(4).setTab(4).setResistance(0.5f).setHardness(0.5f).setHarvestTool("shovel").setTicking(true).setTickHandler(new BlockTickHandler(){

            @Override
            public void onTick(World world, int x, int y, int z, Random rand) {
                if (world.func_147437_c(x, y + 1, z)) {
                    boolean nearbyWater = false;
                    int chance = 0;
                    for (int i = x - 1; i <= x + 1; ++i) {
                        for (int j = z - 1; j <= z + 1; ++j) {
                            if (!world.func_147439_a(i, y, j).func_149667_c(Blocks.field_150355_j)) continue;
                            nearbyWater = true;
                            break;
                        }
                        if (nearbyWater) break;
                    }
                    if ((chance = world.func_72896_J() || nearbyWater ? rand.nextInt(10) : rand.nextInt(25)) == 0) {
                        world.func_147449_b(x, y, z, compostedDirt);
                    }
                }
            }
        }).build();
        compostedDirt = new BlockBuilder().setName("Composted Dirt").setMaterial(15).setSound(3).setTab(4).setResistance(0.5f).setHardness(0.5f).setHarvestTool("shovel").setDropMultipleItemsHandler(new BlockDropsHandler.DropMultiItemsHandler(){

            @Override
            public ArrayList<ItemStack> onGetMultiDropItems(World world, int x, int y, int z, int metadata, int fortune) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(new ItemStack(Blocks.field_150346_d, 1, 0));
                int i = 0;
                while ((double)i < (double)(3 + world.field_73012_v.nextInt(3)) + Math.floor((double)fortune * 1.5)) {
                    drops.add(new ItemStack(Items.field_151100_aR, 1, 15));
                    ++i;
                }
                return drops;
            }
        }).build();
        GameRegistry.registerBlock((Block)testBlock, (String)"test_block");
        GameRegistry.registerBlock((Block)trueBlock, (String)"true_block");
        GameRegistry.registerBlock((Block)falseBlock, (String)"false_block");
        GameRegistry.registerBlock((Block)compostingDirt, (String)"composting_dirt");
        GameRegistry.registerBlock((Block)compostedDirt, (String)"composted_dirt");
        for (Block block : compostableBlocks = new Block[]{Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150434_aF, Blocks.field_150407_cf, Blocks.field_150395_bd, Blocks.field_150392_bi, Blocks.field_150345_g, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150398_cm, Blocks.field_150329_H, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_150388_bm, Blocks.field_150328_O, Blocks.field_150327_N}) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
        }
        for (Item item : compostableItems = new Item[]{Items.field_151078_bh, Items.field_151034_e, Items.field_151025_P, Items.field_151115_aP, Items.field_151076_bf, Items.field_151147_al, Items.field_151082_bd, Items.field_151110_aK, Items.field_151015_O, Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_151127_ba, Items.field_151174_bG, Items.field_151168_bH, Items.field_151120_aE}) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(item, 1, Short.MAX_VALUE));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(compostingDirt, 1), new Object[]{"AAA", "ABA", "AAA", Character.valueOf('A'), "compostable", Character.valueOf('B'), Blocks.field_150346_d}));
    }
}

