/*
 * Decompiled with CFR 0.152.
 */
package com.lumi.lots;

import com.lumi.lots.audio.music.DisplayPlayingTrackName;
import com.lumi.lots.audio.music.overwrite.Music;
import com.lumi.lots.blocks.BlockBuilder;
import com.lumi.lots.blocks.BlockDropsHandler;
import com.lumi.lots.blocks.BlockTickHandler;
import com.lumi.lots.blocks.overwrite.Leaves;
import com.lumi.lots.config.Config;
import com.lumi.lots.gui.MovementHandler;
import com.lumi.lots.gui.TextFieldFocusChecks.TextFieldFocus;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lumis_lots", version="@VERSION@")
public class LumisCore {
    public static final String MOD_ID = "lumis_lots";
    public static final String MOD_VERSION = "@VERSION@";
    private static final Logger logger = LogManager.getLogger((String)"lumis_lots");
    public static Config config;
    public boolean etFuturumInstalled;
    @Mod.Instance(value="lumis_lots")
    public static LumisCore INSTANCE;
    public static Block compostingDirt;
    public static Block compostedDirt;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("Lumi says \"Hello Forge world!\"");
        logger.info("Lumi says \"Hello Forge world!\"");
        if (event.getSide().isClient()) {
            if (LumisCore.config.invMovement) {
                FMLCommonHandler.instance().bus().register((Object)new TextFieldFocus());
                FMLCommonHandler.instance().bus().register((Object)new MovementHandler());
            }
            if (LumisCore.config.displayTrackName) {
                MinecraftForge.EVENT_BUS.register((Object)new DisplayPlayingTrackName());
            }
            if (!LumisCore.config.doMusicCooldown) {
                Minecraft mc = Minecraft.func_71410_x();
                try {
                    Field tickerField = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"mcMusicTicker", "field_147126_aw"});
                    tickerField.setAccessible(true);
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(tickerField, tickerField.getModifiers() & 0xFFFFFFEF);
                    tickerField.set(mc, (Object)new Music(mc));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)new Leaves());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.etFuturumInstalled = Loader.isModLoaded((String)"etfuturum");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Item[] compostableItems;
        int i;
        Block[] compostableBlocks;
        config = Config.load();
        config.save();
        compostingDirt = new BlockBuilder().setName("Composting Dirt").setMaterial(15).setSound(4).setTab(4).setResistance(0.5f).setHardness(0.5f).setHarvestTool("shovel").setTicking(true).setMapColour(MapColor.field_151650_B).setTickHandler(new BlockTickHandler(){

            @Override
            public void onTick(World world, int x, int y, int z, Random rand) {
                if (world.func_147437_c(x, y + 1, z)) {
                    boolean nearbyWater = false;
                    int chance = 0;
                    for (int i = x - 1; i <= x + 1; ++i) {
                        for (int j = z - 1; j <= z + 1; ++j) {
                            if (!world.func_147439_a(i, y, j).func_149667_c(Blocks.field_150355_j)) continue;
                            nearbyWater = true;
                            break;
                        }
                        if (nearbyWater) break;
                    }
                    if ((chance = world.func_72896_J() || nearbyWater ? rand.nextInt(10) : rand.nextInt(25)) == 0) {
                        world.func_147449_b(x, y, z, compostedDirt);
                    }
                }
            }
        }).build();
        compostedDirt = new BlockBuilder().setName("Composted Dirt").setMaterial(15).setSound(3).setTab(4).setResistance(0.5f).setHardness(0.5f).setHarvestTool("shovel").setMapColour(MapColor.field_151663_o).setDropMultipleItemsHandler(new BlockDropsHandler.DropMultiItemsHandler(){

            @Override
            public ArrayList<ItemStack> onGetMultiDropItems(World world, int x, int y, int z, int metadata, int fortune) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(new ItemStack(Blocks.field_150346_d, 1, 0));
                int i = 0;
                while ((double)i < (double)(3 + world.field_73012_v.nextInt(3)) + Math.floor((double)fortune * 1.5)) {
                    drops.add(new ItemStack(Items.field_151100_aR, 1, 15));
                    ++i;
                }
                return drops;
            }
        }).build();
        GameRegistry.registerBlock((Block)compostingDirt, (String)"composting_dirt");
        GameRegistry.registerBlock((Block)compostedDirt, (String)"composted_dirt");
        for (Block block : compostableBlocks = new Block[]{Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150434_aF, Blocks.field_150407_cf, Blocks.field_150395_bd, Blocks.field_150392_bi, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_150327_N}) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(block));
        }
        for (i = 0; i < 4; ++i) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(Blocks.field_150345_g, 1, i));
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack((Block)Blocks.field_150362_t, 1, i));
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack((Block)Blocks.field_150361_u, 1, i));
        }
        for (i = 0; i < 9; ++i) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack((Block)Blocks.field_150328_O, 1, i));
        }
        for (i = 0; i < 3; ++i) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack((Block)Blocks.field_150329_H, 1, i));
        }
        for (i = 0; i < 6; ++i) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack((Block)Blocks.field_150398_cm, 1, i));
        }
        for (Item item : compostableItems = new Item[]{Items.field_151078_bh, Items.field_151034_e, Items.field_151025_P, Items.field_151076_bf, Items.field_151147_al, Items.field_151082_bd, Items.field_151110_aK, Items.field_151015_O, Items.field_151014_N, Items.field_151081_bc, Items.field_151075_bm, Items.field_151080_bb, Items.field_151127_ba, Items.field_151174_bG, Items.field_151168_bH, Items.field_151120_aE}) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(item));
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            OreDictionary.registerOre((String)"compostable", (ItemStack)new ItemStack(Items.field_151115_aP, 1, i2));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(compostingDirt, 1), new Object[]{"AAA", "ABA", "AAA", Character.valueOf('A'), "compostable", Character.valueOf('B'), Blocks.field_150346_d}));
    }
}

