/*
 * Decompiled with CFR 0.152.
 */
package com.lumi.lots.blocks;

import com.lumi.lots.blocks.BlockDropsHandler;
import com.lumi.lots.blocks.BlockTickHandler;
import com.lumi.lots.blocks.BlockToolHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LumisBlocks
extends Block {
    private final BlockTickHandler tickHandler;
    private final BlockDropsHandler.DropAmountFortuneHandler dropAmountFortuneHandler;
    private final BlockDropsHandler.DropAmountHandler dropAmountHandler;
    private final BlockDropsHandler.DropTypeHandler dropTypeHandler;
    private final BlockDropsHandler.DropMultiItemsHandler dropMultipleItemsHandler;
    private BlockToolHandler.ToolEffectiveHandler checkEffectiveToolHandler = null;
    private BlockToolHandler.PlayerRelativeBlockHardnessHandler playerRelativeBlockHardnessHandler = null;
    private Boolean useToolEffectiveHandler;
    private MapColor mapColour;
    private static final Material[] materials = new Material[]{Material.field_151579_a, Material.field_151574_g, Material.field_151570_A, Material.field_151568_F, Material.field_151593_r, Material.field_151594_q, Material.field_151571_B, Material.field_151580_n, Material.field_151589_v, Material.field_151596_z, Material.field_151566_D, Material.field_151581_o, Material.field_151592_s, Material.field_151572_C, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151573_f, Material.field_151587_i, Material.field_151584_j, Material.field_151598_x, Material.field_76233_E, Material.field_151585_k, Material.field_151567_E, Material.field_151591_t, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y, Material.field_151583_m, Material.field_151590_u, Material.field_151582_l, Material.field_151586_h, Material.field_151569_G, Material.field_151575_d};
    private static final Block.SoundType[] sounds = new Block.SoundType[]{Block.field_149788_p, Block.field_149775_l, Block.field_149778_k, Block.field_149779_h, Block.field_149767_g, Block.field_149774_o, Block.field_149777_j, Block.field_149780_i, Block.field_149776_m, Block.field_149773_n, Block.field_149769_e, Block.field_149766_f};
    private static final CreativeTabs[] tabs = new CreativeTabs[]{CreativeTabs.field_78027_g, CreativeTabs.field_78030_b, CreativeTabs.field_78038_k, CreativeTabs.field_78037_j, CreativeTabs.field_78031_c, CreativeTabs.field_78039_h, CreativeTabs.field_78036_m, CreativeTabs.field_78035_l, CreativeTabs.field_78026_f, CreativeTabs.field_78028_d, CreativeTabs.field_78040_i, CreativeTabs.field_78029_e};

    public LumisBlocks(int material, String name, float hardness, float resistance, String harvestTool, int harvestLevel, int sound, int tab, boolean ticks, BlockTickHandler tickHandler, BlockDropsHandler.DropAmountFortuneHandler dropAmountFortuneHandler, BlockDropsHandler.DropAmountHandler dropAmountHandler, BlockDropsHandler.DropTypeHandler dropTypeHandler, BlockDropsHandler.DropMultiItemsHandler dropMultipleItemsHandler, BlockToolHandler.ToolEffectiveHandler checkEffectiveToolHandler, BlockToolHandler.PlayerRelativeBlockHardnessHandler playerRelativeBlockHardnessHandler, boolean useToolEffectiveHandler, MapColor mapColour) {
        super(materials[material]);
        name = name.toLowerCase().replace(" ", "_");
        this.func_149663_c(name);
        this.func_149658_d(String.format("lumis_lots:%s", name));
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setHarvestLevel(harvestTool, harvestLevel);
        this.func_149672_a(sounds[sound]);
        if (tab > -1) {
            this.func_149647_a(tabs[tab]);
        }
        if (ticks) {
            this.func_149675_a(true);
        }
        this.tickHandler = tickHandler;
        this.dropAmountFortuneHandler = dropAmountFortuneHandler;
        this.dropAmountHandler = dropAmountHandler;
        this.dropTypeHandler = dropTypeHandler;
        this.dropMultipleItemsHandler = dropMultipleItemsHandler;
        this.checkEffectiveToolHandler = checkEffectiveToolHandler;
        this.playerRelativeBlockHardnessHandler = playerRelativeBlockHardnessHandler;
        this.useToolEffectiveHandler = useToolEffectiveHandler;
        this.mapColour = mapColour;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.tickHandler != null && !world.field_72995_K) {
            this.tickHandler.onTick(world, x, y, z, rand);
        }
    }

    public int func_149679_a(int fortune, Random rand) {
        if (this.dropAmountFortuneHandler != null) {
            return this.dropAmountFortuneHandler.onDropFortune(fortune, rand);
        }
        return 1;
    }

    public int func_149745_a(Random rand) {
        if (this.dropAmountHandler != null) {
            return this.dropAmountHandler.onDrop(rand);
        }
        return 1;
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        if (this.dropTypeHandler != null) {
            return this.dropTypeHandler.onGetDropItem(metadata, rand, fortune);
        }
        return super.func_149650_a(metadata, rand, fortune);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.dropMultipleItemsHandler != null) {
            return this.dropMultipleItemsHandler.onGetMultiDropItems(world, x, y, z, metadata, fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public String getHarvestTool(int metadata) {
        if (this.useToolEffectiveHandler.booleanValue()) {
            return null;
        }
        return super.getHarvestTool(metadata);
    }

    public int getHarvestLevel(int metadata) {
        if (this.useToolEffectiveHandler.booleanValue()) {
            return 0;
        }
        return super.getHarvestLevel(metadata);
    }

    public boolean isToolEffective(String type, int metadata) {
        if (this.checkEffectiveToolHandler != null) {
            return this.checkEffectiveToolHandler.onCheckToolEffective(type, metadata);
        }
        return super.isToolEffective(type, metadata);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        float originalValue = super.func_149737_a(player, world, x, y, z);
        if (this.playerRelativeBlockHardnessHandler != null) {
            float newValue = this.playerRelativeBlockHardnessHandler.onGetPlayerRelativeBlockHardness(player, originalValue);
            if (newValue < 0.0f) {
                return originalValue;
            }
            return newValue;
        }
        return originalValue;
    }

    public MapColor func_149728_f(int p_149728_1_) {
        if (this.mapColour != null) {
            return this.mapColour;
        }
        return super.func_149728_f(p_149728_1_);
    }
}

