/*
 * Decompiled with CFR 0.152.
 */
package com.lumi.lots.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class Config {
    public boolean invMovement = true;
    public boolean displayTrackName = false;
    public boolean doMusicCooldown = false;
    public int etFuturumDeepslateYLevel = 22;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final File configFile = new File(String.format("config/%s.json", "lumis_lots"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Config load() {
        if (!configFile.exists()) {
            Config defaultConfig = new Config();
            defaultConfig.save();
            return defaultConfig;
        }
        try (FileReader reader = new FileReader(configFile);){
            Config config = (Config)gson.fromJson((Reader)reader, Config.class);
            return config;
        }
        catch (Exception ignore) {
            return new Config();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

