/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.google.common.base.Predicates;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.hail.create_fantasizing.data.CFADataComponents;
import dev.hail.create_fantasizing.item.block_placer.BPBrush;
import dev.hail.create_fantasizing.item.block_placer.BPCuboidBrush;
import dev.hail.create_fantasizing.item.block_placer.BPCylinderBrush;
import dev.hail.create_fantasizing.item.block_placer.BPDynamicBrush;
import dev.hail.create_fantasizing.item.block_placer.BPSphereBrush;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerBrushes;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerItemRenderer;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerScreen;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerTools;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BlockPlacerItem
extends ZapperItem {
    public BlockPlacerItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new BlockPlacerItemRenderer()));
    }

    public boolean isEnchantable(@NotNull ItemStack itemstack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.FLAME) || enchantment.is(Enchantments.POWER) || enchantment.is(Enchantments.PUNCH)) {
            return false;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public Component validateUsage(ItemStack item) {
        if (!item.has(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            return CreateLang.translateDirect((String)"terrainzapper.shiftRightClickToSet", (Object[])new Object[0]);
        }
        return super.validateUsage(item);
    }

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        BlockPlacerTools tool = (BlockPlacerTools)((Object)stack.getOrDefault(CFADataComponents.SHAPER_TOOL, (Object)BlockPlacerTools.Fill));
        return !tool.requiresSelectedBlock();
    }

    protected boolean activate(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data) {
        return false;
    }

    public float activate(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data, InteractionHand hand) {
        BlockPos targetPos = raytrace.getBlockPos();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        BPBrush brush = ((BlockPlacerBrushes)((Object)stack.getOrDefault(CFADataComponents.SHAPER_BRUSH, (Object)BlockPlacerBrushes.Cuboid))).get();
        BlockPos params = (BlockPos)stack.get(AllDataComponents.SHAPER_BRUSH_PARAMS);
        float multiplier = this.sizeMultiplier(params, brush);
        PlacementOptions option = (PlacementOptions)stack.getOrDefault(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)PlacementOptions.Merged);
        BlockPlacerTools tool = (BlockPlacerTools)((Object)stack.getOrDefault(CFADataComponents.SHAPER_TOOL, (Object)BlockPlacerTools.Fill));
        brush.set(params.getX(), params.getY(), params.getZ());
        targetPos = targetPos.offset((Vec3i)brush.getOffset(player.getLookAngle(), raytrace.getDirection(), option));
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.getDirection(), affectedPositions, tool);
        brush.redirectTool(tool).run(world, affectedPositions, stateToUse, data, player, stack, hand, BlockPlacerItem.applyPattern(affectedPositions, stack));
        return multiplier;
    }

    public int activateCalculation(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace) {
        BlockPos targetPos = raytrace.getBlockPos();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        BPBrush brush = ((BlockPlacerBrushes)((Object)stack.getOrDefault(CFADataComponents.SHAPER_BRUSH, (Object)BlockPlacerBrushes.Cuboid))).get();
        BlockPos params = (BlockPos)stack.get(AllDataComponents.SHAPER_BRUSH_PARAMS);
        PlacementOptions option = (PlacementOptions)stack.getOrDefault(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)PlacementOptions.Merged);
        BlockPlacerTools tool = (BlockPlacerTools)((Object)stack.getOrDefault(CFADataComponents.SHAPER_TOOL, (Object)BlockPlacerTools.Fill));
        if (params != null) {
            brush.set(params.getX(), params.getY(), params.getZ());
        }
        targetPos = targetPos.offset((Vec3i)brush.getOffset(player.getLookAngle(), raytrace.getDirection(), option));
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.getDirection(), affectedPositions, tool);
        return brush.redirectTool(tool).runCalculate(world, affectedPositions, stateToUse);
    }

    public static PlacementPatterns applyPattern(List<BlockPos> blocksIn, ItemStack stack) {
        PlacementPatterns pattern = !stack.has(AllDataComponents.PLACEMENT_PATTERN) ? PlacementPatterns.Solid : (PlacementPatterns)stack.get(AllDataComponents.PLACEMENT_PATTERN);
        Object filter = Predicates.alwaysFalse();
        switch (pattern) {
            case Checkered: {
                filter = pos -> (pos.getX() + pos.getY() + pos.getZ()) % 2 == 0;
                break;
            }
            case InverseCheckered: {
                filter = pos -> (pos.getX() + pos.getY() + pos.getZ()) % 2 != 0;
                break;
            }
        }
        blocksIn.removeIf((Predicate<BlockPos>)filter);
        return pattern;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockState stateToUse = Blocks.AIR.defaultBlockState();
            if (pStack.has(AllDataComponents.SHAPER_BLOCK_USED)) {
                stateToUse = (BlockState)pStack.get(AllDataComponents.SHAPER_BLOCK_USED);
            }
            stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
            Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
            Vec3 range = player.getLookAngle().scale((double)this.getZappingRange(pStack));
            BlockHitResult raytrace = pLevel.clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (stateToUse != null) {
                int invAmount = BlockPlacerTools.calculateItemsInInventory(stateToUse.getBlock(), true, player, pStack.getEnchantmentLevel(pLevel.holderOrThrow(Enchantments.INFINITY)) >= 1);
                int selSize = this.activateCalculation(pLevel, player, pStack, stateToUse, raytrace);
                if (!pStack.has(CFADataComponents.BLOCK_AMOUNT) || (Integer)pStack.get(CFADataComponents.BLOCK_AMOUNT) != invAmount) {
                    pStack.set(CFADataComponents.BLOCK_AMOUNT, (Object)invAmount);
                }
                if (!pStack.has(CFADataComponents.PLACE_SIZE) || (Integer)pStack.get(CFADataComponents.PLACE_SIZE) != selSize) {
                    pStack.set(CFADataComponents.PLACE_SIZE, (Object)selSize);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean lookingAtBlock;
        boolean mainHand;
        ItemStack item = player.getItemInHand(hand);
        boolean bl = mainHand = hand == InteractionHand.MAIN_HAND;
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.openHandgunGUI(item, hand));
                player.getCooldowns().addCooldown(item.getItem(), 10);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        BlockState stateToUse = Blocks.AIR.defaultBlockState();
        if (item.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            stateToUse = (BlockState)item.get(AllDataComponents.SHAPER_BLOCK_USED);
        }
        stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
        CompoundTag data = null;
        if (item.has(AllDataComponents.SHAPER_BLOCK_DATA)) {
            data = (CompoundTag)item.get(AllDataComponents.SHAPER_BLOCK_DATA);
        }
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 range = player.getLookAngle().scale((double)this.getZappingRange(item));
        BlockHitResult raytrace = level.clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (boolean)mainHand, (Vec3)new Vec3((double)0.35f, (double)-0.1f, 1.0));
        BlockPos lookingPos = raytrace.getBlockPos();
        int amount = item.has(CFADataComponents.BLOCK_AMOUNT) ? (Integer)item.get(CFADataComponents.BLOCK_AMOUNT) : 0;
        int size = item.has(CFADataComponents.PLACE_SIZE) ? (Integer)item.get(CFADataComponents.PLACE_SIZE) : 0;
        boolean items = (amount >= size || player.isCreative()) && size != 0 || size == 999999;
        boolean bl2 = lookingAtBlock = level.getWorldBorder().isWithinBounds(lookingPos) && raytrace.getType() != HitResult.Type.MISS;
        if (level.isClientSide) {
            if (!(player.isShiftKeyDown() || items && lookingAtBlock)) {
                if (size != 0 && size != 999999 && lookingAtBlock) {
                    player.displayClientMessage((Component)Component.translatable((String)"item.create_fantasizing.block_placer.not_enough_blocks").append(" " + amount + "/" + size).withStyle(ChatFormatting.RED), true);
                }
                AllSoundEvents.DENY.play(level, player, (Vec3i)player.blockPosition());
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
            }
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (!(player.isShiftKeyDown() || items && lookingAtBlock)) {
            player.getCooldowns().addCooldown(item.getItem(), 10);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        if (!player.isShiftKeyDown() && items && lookingAtBlock) {
            float multiplier = this.activate(level, player, item, stateToUse, raytrace, data, hand);
            int cooldown = (int)(multiplier * (float)this.getCooldownDelay(item));
            ShootableGadgetItemMethods.applyCooldown((Player)player, (ItemStack)item, (InteractionHand)hand, arg_0 -> ((BlockPlacerItem)this).isZapper(arg_0), (int)Math.max(cooldown, 5));
            ShootableGadgetItemMethods.sendPackets((Player)player, b -> new ZapperBeamPacket(barrelPos, hand, b.booleanValue(), raytrace.getLocation()));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        return super.use(level, player, hand);
    }

    public float sizeMultiplier(BlockPos params, BPBrush brush) {
        float size = 16.0f;
        float radius = 6.0f;
        float radiusSize = (int)((double)radius * 1.25);
        float max = 1.0f;
        if (brush instanceof BPCuboidBrush) {
            max = size;
        }
        if (brush instanceof BPSphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof BPCylinderBrush) {
            max = radius;
        }
        if (brush instanceof BPDynamicBrush) {
            max = radiusSize;
        }
        float x = params.getX();
        float y = params.getY();
        float z = params.getZ();
        return x * y * z / (max * max * max);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void openHandgunGUI(ItemStack item, InteractionHand hand) {
        ScreenOpener.open((Screen)new BlockPlacerScreen(item, hand));
    }

    protected int getCooldownDelay(ItemStack item) {
        return 2;
    }

    protected int getZappingRange(ItemStack stack) {
        return 128;
    }

    public static void configureSettings(ItemStack stack, PlacementPatterns pattern, BlockPlacerBrushes brush, int brushParamX, int brushParamY, int brushParamZ, BlockPlacerTools tool, PlacementOptions placement) {
        stack.set(AllDataComponents.PLACEMENT_PATTERN, (Object)pattern);
        stack.set(CFADataComponents.SHAPER_BRUSH, (Object)brush);
        stack.set(AllDataComponents.SHAPER_BRUSH_PARAMS, (Object)new BlockPos(brushParamX, brushParamY, brushParamZ));
        stack.set(CFADataComponents.SHAPER_TOOL, (Object)tool);
        stack.set(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)placement);
    }
}

