/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.foundation.gui.AllIcons;
import dev.hail.create_fantasizing.CFAConfig;
import dev.hail.create_fantasizing.data.CFATags;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.lang.Lang;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public enum BlockPlacerTools implements StringRepresentable
{
    Fill(AllIcons.I_FILL),
    Place(AllIcons.I_PLACE),
    Replace(AllIcons.I_REPLACE),
    Clear(AllIcons.I_CLEAR),
    Overlay(AllIcons.I_OVERLAY);

    public static final TagKey<Block> UNBREAKABLE_TAG;
    public static final Codec<BlockPlacerTools> CODEC;
    public static final StreamCodec<ByteBuf, BlockPlacerTools> STREAM_CODEC;
    public final String translationKey = Lang.asId((String)this.name());
    public final AllIcons icon;
    static int tick;

    private BlockPlacerTools(AllIcons icon) {
        this.icon = icon;
    }

    public String getSerializedName() {
        return Lang.asId((String)this.name());
    }

    public boolean requiresSelectedBlock() {
        return this != Clear;
    }

    public void run(Level world, List<BlockPos> targetPositions, BlockState paintedState, CompoundTag data, Player player, ItemStack stack, InteractionHand hand, PlacementPatterns patterns) {
        switch (this.ordinal()) {
            case 3: {
                for (BlockPos p : targetPositions) {
                    BlockPlacerTools.zapperFunction(world, Blocks.AIR.defaultBlockState(), p, world.getBlockState(p), stack, player, hand, data, patterns);
                }
                break;
            }
            case 0: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.getBlockState(p);
                    if (!BlockPlacerTools.isReplaceable(toReplace)) continue;
                    BlockPlacerTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
            case 4: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace;
                    BlockState toOverlay = world.getBlockState(p);
                    if (BlockPlacerTools.isReplaceable(toOverlay) || toOverlay == paintedState || !BlockPlacerTools.isReplaceable(toReplace = world.getBlockState(p = p.above()))) continue;
                    BlockPlacerTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
            case 1: {
                for (BlockPos p : targetPositions) {
                    BlockPlacerTools.zapperFunction(world, paintedState, p, world.getBlockState(p), stack, player, hand, data, patterns);
                }
                break;
            }
            case 2: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.getBlockState(p);
                    if (BlockPlacerTools.isReplaceable(toReplace)) continue;
                    BlockPlacerTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
        }
    }

    public int runCalculate(Level world, List<BlockPos> targetPositions, BlockState paintedState) {
        int size = 0;
        switch (this.ordinal()) {
            case 3: {
                return 999999;
            }
            case 1: {
                for (BlockPos p : targetPositions) {
                    if (BlockPlacerTools.meetRequirements(world, paintedState, p, world.getBlockState(p)) != 0) continue;
                    ++size;
                }
                break;
            }
            case 0: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.getBlockState(p);
                    if (!BlockPlacerTools.isReplaceable(toReplace) || BlockPlacerTools.meetRequirements(world, paintedState, p, toReplace) != 0) continue;
                    ++size;
                }
                break;
            }
            case 4: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace;
                    BlockState toOverlay = world.getBlockState(p);
                    if (BlockPlacerTools.isReplaceable(toOverlay) || toOverlay == paintedState || !BlockPlacerTools.isReplaceable(toReplace = world.getBlockState(p = p.above())) || BlockPlacerTools.meetRequirements(world, paintedState, p, toReplace) != 0) continue;
                    ++size;
                }
                break;
            }
            case 2: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.getBlockState(p);
                    if (BlockPlacerTools.isReplaceable(toReplace) || BlockPlacerTools.meetRequirements(world, paintedState, p, toReplace) != 0) continue;
                    ++size;
                }
                break;
            }
        }
        return size;
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.canBeReplaced();
    }

    public static void zapperFunction(Level pLevel, BlockState paintState, BlockPos replacePos, BlockState replaceState, ItemStack stack, Player player, InteractionHand hand, CompoundTag data, PlacementPatterns patterns) {
        block12: {
            Random r = new Random();
            switch (patterns) {
                case Chance25: {
                    if (r.nextBoolean() || r.nextBoolean()) {
                        break;
                    }
                    break block12;
                }
                case Chance50: {
                    if (r.nextBoolean()) {
                        break;
                    }
                    break block12;
                }
                case Chance75: {
                    if (r.nextBoolean() && r.nextBoolean()) {
                        break;
                    }
                    break block12;
                }
                default: {
                    break block12;
                }
            }
            return;
        }
        if (BlockPlacerTools.meetRequirements(pLevel, paintState, replacePos, replaceState) != 0) {
            return;
        }
        Block paintBlock = paintState.getBlock();
        boolean creative = player.isCreative();
        if (!(creative || paintState.isAir() || BlockPlacerTools.hasItemInInventory(paintBlock, player))) {
            return;
        }
        if (!creative && !paintState.isAir()) {
            BlockPlacerTools.calculateItemsInInventory(paintBlock, false, player, stack.getEnchantmentLevel(pLevel.holderOrThrow(Enchantments.INFINITY)) >= 1);
        }
        BlockPlacerTools.dropResources(replaceState, pLevel, replacePos, replaceState.hasBlockEntity() ? pLevel.getBlockEntity(replacePos) : null, (Entity)player, stack);
        paintBlock.setPlacedBy(pLevel, replacePos, paintState, (LivingEntity)player, stack);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_PLACE, replacePos, GameEvent.Context.of((Entity)player, (BlockState)paintState));
        pLevel.setBlock(replacePos, paintState, 2);
        pLevel.setBlockAndUpdate(replacePos, paintState);
        ZapperItem.setBlockEntityData((Level)pLevel, (BlockPos)replacePos, (BlockState)paintState, (CompoundTag)data, (Player)player);
        if (!creative) {
            stack.hurtAndBreak(2, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    public static boolean hasItemInInventory(Block paintBlock, Player player) {
        Inventory inv = player.getInventory();
        int size = inv.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item.isEmpty() || !item.is(paintBlock.asItem())) continue;
            return true;
        }
        return false;
    }

    public static int calculateItemsInInventory(Block paintBlock, boolean calculate, Player player, boolean generator) {
        int amount = 0;
        Inventory inv = player.getInventory();
        int size = inv.getContainerSize();
        if (paintBlock.defaultBlockState().is(CFATags.RENEWABLE_BLOCKS) && generator) {
            amount = size * 128;
        } else {
            for (int slot = 0; slot < size; ++slot) {
                ItemStack item = inv.getItem(slot);
                if (item.isEmpty() || !item.is(paintBlock.asItem())) continue;
                if (!calculate) {
                    item.shrink(1);
                    return 1;
                }
                amount += item.getCount();
            }
        }
        return amount;
    }

    public static boolean blacklist(BlockState toBlacklist) {
        return toBlacklist.is(AllTags.AllBlockTags.NON_MOVABLE.tag) || AllTags.AllBlockTags.SAFE_NBT.matches(toBlacklist) || toBlacklist.is(UNBREAKABLE_TAG);
    }

    public static int meetRequirements(Level pLevel, BlockState paintState, BlockPos replacePos, BlockState replaceState) {
        if (paintState == replaceState) {
            return 8;
        }
        if ((double)replaceState.getBlock().defaultDestroyTime() > CFAConfig.blockPlacerPower && !replaceState.isAir() && !replaceState.liquid()) {
            return 6;
        }
        if (BlockPlacerTools.blacklist(replaceState)) {
            return 4;
        }
        if (!paintState.canSurvive((LevelReader)pLevel, replacePos)) {
            return 4;
        }
        return pLevel.getWorldBorder().isWithinBounds(replacePos) ? 0 : 4;
    }

    public static void dropResources(BlockState pState, Level pLevel, BlockPos pPos, @Nullable BlockEntity pBlockEntity, @Nullable Entity pEntity, ItemStack pTool) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockPos dropPos = pEntity != null ? pEntity.getOnPos().above() : pPos;
            Block.getDrops((BlockState)pState, (ServerLevel)serverLevel, (BlockPos)pPos, (BlockEntity)pBlockEntity, (Entity)pEntity, (ItemStack)pTool).forEach(p_49944_ -> BlockPlacerTools.popResource(pLevel, dropPos, p_49944_));
            pState.spawnAfterBreak(serverLevel, pPos, pTool, false);
            int exp = pState.getExpDrop((LevelAccessor)serverLevel, pPos, pBlockEntity, pEntity, pTool);
            if (exp > 0) {
                pState.getBlock().popExperience(serverLevel, dropPos, exp);
            }
        }
    }

    public static void itemTransferTick(Level pLevel, Player player) {
        ++tick;
        if ((tick %= 2) == 1) {
            Vec3 center = BlockPlacerTools.getCenterPos((Entity)player);
            AABB bb = new AABB(center, center).inflate(64.0);
            for (ItemEntity entity : pLevel.getEntitiesOfClass(ItemEntity.class, bb)) {
                float limit;
                int range;
                if (entity == null || entity.isRemoved() || !entity.getTags().contains("sendToNearestPlayer")) continue;
                boolean fast = entity.getTags().contains("sendToNearestPlayerInstant");
                Vec3 diff = BlockPlacerTools.getCenterPos((Entity)entity).subtract(center);
                double distance = diff.length();
                int n = range = fast ? 64 : 32;
                if (distance > (double)range) continue;
                Vec3 pushVec = diff.normalize().scale(((double)range - distance) * -1.0);
                float forceFactor = 0.0078125f;
                Vec3 force = pushVec.scale((double)forceFactor * (fast ? 1.0 : 0.5));
                entity.push(force.x, force.y, force.z);
                entity.fallDistance = 0.0f;
                entity.hurtMarked = true;
                float f = limit = fast ? 4.0f : 2.0f;
                Vec3 currentMovement = entity.getDeltaMovement();
                if (!(currentMovement.length() > (double)limit)) continue;
                Vec3 limitedMovement = currentMovement.normalize().scale((double)limit);
                entity.setDeltaMovement(limitedMovement);
            }
        }
    }

    public static Vec3 getCenterPos(Entity entity) {
        AABB boundingBox = entity.getBoundingBox();
        double centerX = (boundingBox.minX + boundingBox.maxX) / 2.0;
        double centerY = (boundingBox.minY + boundingBox.maxY) / 2.0;
        double centerZ = (boundingBox.minZ + boundingBox.maxZ) / 2.0;
        return new Vec3(centerX, centerY, centerZ);
    }

    public static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)pPos.getX() + 0.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25);
        double d2 = (double)pPos.getY() + 0.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.getZ() + 0.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25);
        ItemEntity item = new ItemEntity(pLevel, d1, d2, d3, pStack);
        item.addTag("sendToNearestPlayerInstant");
        BlockPlacerTools.popResource(pLevel, () -> item, pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.isClientSide && !pStack.isEmpty() && pLevel.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !pLevel.restoringBlockSnapshots) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    static {
        UNBREAKABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"wither_immune"));
        CODEC = StringRepresentable.fromValues(BlockPlacerTools::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(BlockPlacerTools.class);
        tick = 0;
    }
}

