/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.block.compat_engine;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.hail.create_fantasizing.block.compat_engine.CompactEngineEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.ModelFile;

@ParametersAreNonnullByDefault
public abstract class CompactEngineBlock
extends DirectionalKineticBlock
implements IBE<CompactEngineEntity> {
    public CompactEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.MOTOR_BLOCK.get((Direction)state.getValue((Property)FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() || preferred == null) {
            return super.getStateForPlacement(context);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)preferred);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.getValue((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hideStressImpact() {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public Class<CompactEngineEntity> getBlockEntityClass() {
        return CompactEngineEntity.class;
    }

    public static class CompactHydraulicEngineGenerator
    extends SpecialBlockStateGen {
        protected int getXRotation(BlockState state) {
            return state.getValue((Property)FACING) == Direction.DOWN ? 180 : 0;
        }

        protected int getYRotation(BlockState state) {
            return ((Direction)state.getValue((Property)FACING)).getAxis().isVertical() ? 0 : this.horizontalAngle((Direction)state.getValue((Property)FACING));
        }

        public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
            return ((Direction)state.getValue((Property)FACING)).getAxis().isVertical() ? AssetLookup.partialBaseModel(ctx, (RegistrateBlockstateProvider)prov, (String[])new String[]{"vertical"}) : AssetLookup.partialBaseModel(ctx, (RegistrateBlockstateProvider)prov, (String[])new String[0]);
        }
    }
}

