/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.block.transporter;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.hail.create_fantasizing.block.CFABlocks;
import dev.hail.create_fantasizing.block.transporter.TransporterEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransporterBlock
extends Block
implements IWrenchable,
IBE<TransporterEntity>,
ProperWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TransporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (level.isClientSide) {
            return;
        }
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)world, (BlockPos)pos, (BlockState)newState);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        boolean waterFlag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)blockstate.setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterFlag));
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterFlag));
    }

    @NotNull
    protected FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
            }
            case WEST: 
            case EAST: {
                return Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
            }
        }
        return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    public Class<TransporterEntity> getBlockEntityClass() {
        return TransporterEntity.class;
    }

    public BlockEntityType<? extends TransporterEntity> getBlockEntityType() {
        return (BlockEntityType)CFABlocks.TRANSPORTER_ENTITY.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWERED, FACING, WATERLOGGED}));
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        float yOffset;
        if (worldIn.isClientSide) {
            return;
        }
        ItemStack stack = ItemHelper.fromItemEntity((Entity)entityIn);
        if (stack.isEmpty()) {
            return;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        Vec3 openPos = VecHelper.getCenterOf((Vec3i)pos).add(Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).scale(entityIn instanceof ItemEntity ? -0.25 : -0.125));
        Vec3 diff = entityIn.position().subtract(openPos);
        double projectedDiff = direction.getAxis().choose(diff.x, diff.y, diff.z);
        if (projectedDiff < 0.0 == (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE)) {
            return;
        }
        float f = direction == Direction.UP ? 0.25f : (yOffset = direction == Direction.DOWN ? -0.5f : -0.5f);
        if (!PackageEntity.centerPackage((Entity)entityIn, (Vec3)openPos.add(0.0, (double)yOffset, 0.0))) {
            return;
        }
        ItemStack remainder = TransporterBlock.tryInsert(worldIn, pos, stack, false);
        if (remainder.isEmpty()) {
            entityIn.discard();
        }
        if (remainder.getCount() < stack.getCount() && entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).setItem(remainder);
        }
    }

    public static ItemStack tryInsert(Level worldIn, BlockPos pos, ItemStack toInsert, boolean simulate) {
        BlockEntity blockEntity;
        FilteringBehaviour filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, (BehaviourType)FilteringBehaviour.TYPE);
        InvManipulationBehaviour inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, (BehaviourType)InvManipulationBehaviour.TYPE);
        if (inserter == null) {
            return toInsert;
        }
        if (filter != null && !filter.test(toInsert)) {
            return toInsert;
        }
        if (simulate) {
            inserter.simulate();
        }
        ItemStack insert = inserter.insert(toInsert);
        if (!simulate && insert.getCount() != toInsert.getCount() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof FunnelBlockEntity) {
            FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
            funnelBlockEntity.onTransfer(toInsert);
            if (funnelBlockEntity.hasFlap()) {
                funnelBlockEntity.flap(true);
            }
        }
        return insert;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

