/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.block.transporter;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import dev.hail.create_fantasizing.block.CFABlocks;
import dev.hail.create_fantasizing.block.transporter.TransporterBlock;
import dev.hail.create_fantasizing.block.transporter.TransporterFilterSlotPositioning;
import dev.hail.create_fantasizing.block.transporter.TransporterItemHandler;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransporterEntity
extends SmartBlockEntity {
    ItemStack item;
    TransporterItemHandler itemHandler;
    boolean canPickUpItems = false;
    private FilteringBehaviour filtering;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    LerpedFloat flap;
    private final EnumMap<Direction, BlockCapabilityCache<IItemHandler, @Nullable Direction>> capCaches = new EnumMap(Direction.class);

    public TransporterEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.item = ItemStack.EMPTY;
        this.itemHandler = new TransporterItemHandler(this);
        this.flap = this.createChasingFlap();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CFABlocks.TRANSPORTER_ENTITY.get(), (be, context) -> be.itemHandler);
    }

    public void tick() {
        super.tick();
        boolean clientSide = this.level != null && this.level.isClientSide && !this.isVirtual();
        Direction facing = (Direction)this.getBlockState().getValue((Property)TransporterBlock.FACING);
        if (!clientSide) {
            if (this.item.isEmpty() && this.level.getBlockState(this.worldPosition.relative(facing.getOpposite())).getBlock() != CFABlocks.TRANSPORTER.get()) {
                this.handleInput(this.grabCapability(facing.getOpposite()));
            }
            this.handleOutput(this.grabCapability(facing));
        }
    }

    private void handleInput(@Nullable IItemHandler inv) {
        ItemStack extracted;
        if (inv == null || !this.canActivate() || this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        Predicate<ItemStack> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (!(mode != ItemHelper.ExtractionCountMode.UPTO && ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true).isEmpty() || (extracted = ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false)).isEmpty())) {
            this.setItem(extracted);
            return;
        }
        this.invVersionTracker.awaitNewVersion(inv);
    }

    private void handleOutput(@Nullable IItemHandler inv) {
        if (inv == null || !this.canActivate() || this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        this.setItem(ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)this.item, (boolean)false));
        this.invVersionTracker.awaitNewVersion(inv);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private IItemHandler grabCapability(@NotNull Direction facing) {
        BlockPos pos = this.worldPosition.relative(facing);
        if (this.level == null) {
            return null;
        }
        if (this.capCaches.get(facing) == null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                @Nullable BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)facing.getOpposite());
                this.capCaches.put(facing, (BlockCapabilityCache<IItemHandler, Direction>)cache);
                return (IItemHandler)cache.getCapability();
            }
            return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)facing.getOpposite());
        }
        return (IItemHandler)this.capCaches.get(facing).getCapability();
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.invVersionTracker.reset();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        InvManipulationBehaviour invManipulation = new InvManipulationBehaviour((SmartBlockEntity)this, (w, p, s) -> new BlockFace(p, ((Direction)s.getValue((Property)TransporterBlock.FACING)).getOpposite()));
        behaviours.add((BlockEntityBehaviour)invManipulation);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new TransporterFilterSlotPositioning());
        this.filtering.withCallback($ -> this.invVersionTracker.reset());
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(d -> this.canPickUpItems));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    protected boolean canAcceptItem(ItemStack stack) {
        return this.item.isEmpty() && this.canActivate() && this.filtering.test(stack);
    }

    protected boolean canActivate() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)TransporterBlock.POWERED) && (Boolean)blockState.getValue((Property)TransporterBlock.POWERED) == false;
    }

    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    public void destroy() {
        super.destroy();
        if (!this.item.isEmpty() && this.level != null) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.item);
        }
        this.setRemoved();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Item", this.item.saveOptional(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.item = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("Item"));
        if (clientPacket) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, (double)0.05f, LerpedFloat.Chaser.EXP);
    }
}

