/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import dev.hail.create_fantasizing.item.TreeCutterItemRenderer;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TreeCutterItem
extends AxeItem {
    protected BlockPos breakingPos;
    protected Level level;
    protected BlockPos worldPosition;
    public static final Tier STURDY = new Tier(){

        public int getUses() {
            return 2048;
        }

        public float getSpeed() {
            return 9.0f;
        }

        public float getAttackDamageBonus() {
            return 9.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{AllItems.STURDY_SHEET});
        }
    };

    public TreeCutterItem(Item.Properties properties) {
        super(STURDY, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new TreeCutterItemRenderer()));
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (state.is(BlockTags.LOGS) && !miningEntity.isCrouching()) {
            this.level = level;
            this.breakingPos = pos;
            this.worldPosition = pos;
            Optional dynamicTree = TreeCutter.findDynamicTree((Block)state.getBlock(), (BlockPos)this.breakingPos);
            if (dynamicTree.isPresent()) {
                ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(level, null, this::dropItemFromCutTree);
                return true;
            }
            TreeCutter.findTree((BlockGetter)level, (BlockPos)this.breakingPos, (BlockState)state).destroyBlocks(level, null, this::dropItemFromCutTree);
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.distSqr((Vec3i)this.breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)this.breakingPos.subtract((Vec3i)this.worldPosition)).scale((double)(distance / 20.0f)));
        this.level.addFreshEntity((Entity)entity);
    }
}

