/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import dev.hail.create_fantasizing.data.CFADataComponents;
import dev.hail.create_fantasizing.item.CFAItems;
import dev.hail.create_fantasizing.item.block_placer.BPBrush;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerBrushes;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockPlacerRenderHandler {
    private static Supplier<Collection<BlockPos>> renderedPositions;

    public static void tick() {
        BlockPlacerRenderHandler.gatherSelectedBlocks();
        if (renderedPositions == null) {
            return;
        }
        Outliner.getInstance().showCluster((Object)"blockPlacer", (Iterable)renderedPositions.get()).colored(0xBFBFBF).disableLineNormals().lineWidth(0.03125f).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED);
    }

    protected static void gatherSelectedBlocks() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldMain = player.getMainHandItem();
        ItemStack heldOff = player.getOffhandItem();
        boolean zapperInMain = CFAItems.BLOCK_PLACER.isIn(heldMain);
        boolean zapperInOff = CFAItems.BLOCK_PLACER.isIn(heldOff);
        if (!(!zapperInMain || heldMain.has(AllDataComponents.SHAPER_SWAP) && zapperInOff)) {
            BlockPlacerRenderHandler.createBrushOutline(player, heldMain);
            return;
        }
        if (zapperInOff) {
            BlockPlacerRenderHandler.createBrushOutline(player, heldOff);
            return;
        }
        renderedPositions = null;
    }

    public static void createBrushOutline(LocalPlayer player, ItemStack zapper) {
        if (!zapper.has(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            renderedPositions = null;
            return;
        }
        BPBrush brush = ((BlockPlacerBrushes)((Object)zapper.getOrDefault(CFADataComponents.SHAPER_BRUSH, (Object)BlockPlacerBrushes.Cuboid))).get();
        PlacementOptions placement = (PlacementOptions)zapper.getOrDefault(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)PlacementOptions.Merged);
        BlockPlacerTools tool = (BlockPlacerTools)((Object)zapper.getOrDefault(CFADataComponents.SHAPER_TOOL, (Object)BlockPlacerTools.Fill));
        BlockPos params = (BlockPos)zapper.get(AllDataComponents.SHAPER_BRUSH_PARAMS);
        brush.set(params.getX(), params.getY(), params.getZ());
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 range = player.getLookAngle().scale(128.0);
        BlockHitResult raytrace = player.level().clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (raytrace == null || raytrace.getType() == HitResult.Type.MISS) {
            renderedPositions = null;
            return;
        }
        BlockPos pos = raytrace.getBlockPos().offset((Vec3i)brush.getOffset(player.getLookAngle(), raytrace.getDirection(), placement));
        renderedPositions = () -> brush.addToGlobalPositions((LevelAccessor)player.level(), pos, raytrace.getDirection(), new ArrayList<BlockPos>(), tool);
    }
}

