/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.block.transporter;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.logistics.chute.SmartChuteBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import dev.hail.create_fantasizing.block.CFABlocks;
import dev.hail.create_fantasizing.block.transporter.TransporterBlock;
import dev.hail.create_fantasizing.block.transporter.TransporterFilterSlotPositioning;
import dev.hail.create_fantasizing.block.transporter.TransporterItemHandler;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransporterEntity
extends SmartBlockEntity {
    ItemStack item = ItemStack.f_41583_;
    TransporterItemHandler itemHandler = new TransporterItemHandler(this);
    LazyOptional<IItemHandler> lazyHandler = LazyOptional.of(() -> this.itemHandler);
    boolean canPickUpItems = false;
    private FilteringBehaviour filtering;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    LerpedFloat flap = this.createChasingFlap();

    public TransporterEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        super.tick();
        boolean clientSide = this.f_58857_ != null && this.f_58857_.f_46443_ && !this.isVirtual();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransporterBlock.FACING);
        if (!clientSide) {
            if (this.item.m_41619_() && this.f_58857_.m_8055_(this.f_58858_.m_121945_(facing.m_122424_())).m_60734_() != CFABlocks.TRANSPORTER.get()) {
                this.handleInput((IItemHandler)this.grabCapability(facing.m_122424_()).orElse(null));
            }
            this.handleOutput((IItemHandler)this.grabCapability(facing).orElse(null));
        }
    }

    private void handleInput(@Nullable IItemHandler inv) {
        ItemStack extracted;
        if (inv == null || !this.canActivate() || this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        Predicate<ItemStack> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (!(mode != ItemHelper.ExtractionCountMode.UPTO && ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true).m_41619_() || (extracted = ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false)).m_41619_())) {
            this.setItem(extracted);
            return;
        }
        this.invVersionTracker.awaitNewVersion(inv);
    }

    private void handleOutput(@Nullable IItemHandler inv) {
        if (inv == null || !this.canActivate() || this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        this.setItem(ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)this.item, (boolean)false));
        this.invVersionTracker.awaitNewVersion(inv);
    }

    private LazyOptional<IItemHandler> grabCapability(Direction side) {
        BlockPos pos = this.f_58858_.m_121945_(side);
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (be == null) {
            return LazyOptional.empty();
        }
        if (be instanceof ChuteBlockEntity && (side != Direction.DOWN || !(be instanceof SmartChuteBlockEntity))) {
            return LazyOptional.empty();
        }
        return be.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_());
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.invVersionTracker.reset();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        InvManipulationBehaviour invManipulation = new InvManipulationBehaviour((SmartBlockEntity)this, (w, p, s) -> new BlockFace(p, ((Direction)s.m_61143_((Property)TransporterBlock.FACING)).m_122424_()));
        behaviours.add((BlockEntityBehaviour)invManipulation);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new TransporterFilterSlotPositioning());
        this.filtering.withCallback($ -> this.invVersionTracker.reset());
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(d -> this.canPickUpItems));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    protected boolean canAcceptItem(ItemStack stack) {
        return this.item.m_41619_() && this.canActivate() && this.filtering.test(stack);
    }

    protected boolean canActivate() {
        BlockState blockState = this.m_58900_();
        return blockState.m_61138_((Property)TransporterBlock.POWERED) && (Boolean)blockState.m_61143_((Property)TransporterBlock.POWERED) == false;
    }

    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    public void destroy() {
        super.destroy();
        if (!this.item.m_41619_() && this.f_58857_ != null) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.item);
        }
        this.m_7651_();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Item", (Tag)this.item.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.item = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        if (clientPacket) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, (double)0.05f, LerpedFloat.Chaser.EXP);
    }
}

