/*
 * Decompiled with CFR 0.152.
 */
package fr.josephcasanovac.stringdupback;

import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private int stringAmount;
    private boolean dropEnabled;
    private FileConfiguration config;

    public void onEnable() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("resources/config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        this.stringAmount = this.config.getInt("string-amount", 2);
        this.dropEnabled = this.config.getBoolean("drop-enabled", true);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("\u00a7a[StringDupBack] Plugin enabled.");
    }

    public void onDisable() {
        this.getLogger().info("\u00a7c[StringDupBack] Plugin disabled.");
    }

    private boolean isDisarmedTripwire(Block block) {
        Tripwire tripwire;
        if (block.getType() != Material.TRIPWIRE) {
            return false;
        }
        BlockData data = block.getBlockData();
        return data instanceof Tripwire && (tripwire = (Tripwire)data).isDisarmed();
    }

    private void dropString(Block block) {
        if (!this.dropEnabled || this.stringAmount <= 0) {
            return;
        }
        block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.STRING, this.stringAmount));
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.TRIPWIRE) {
            return;
        }
        BlockData data = block.getBlockData();
        if (!(data instanceof Tripwire)) {
            return;
        }
        Tripwire tripwire = (Tripwire)data;
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() == Material.SHEARS) {
            event.setCancelled(true);
            tripwire.setDisarmed(!tripwire.isDisarmed());
            block.setBlockData((BlockData)tripwire);
        } else if (tripwire.isDisarmed()) {
            event.setCancelled(true);
            this.dropString(block);
        }
    }

    @EventHandler
    public void onLiquidFlow(BlockFromToEvent event) {
        if (this.isDisarmedTripwire(event.getToBlock())) {
            event.setCancelled(true);
            this.dropString(event.getToBlock());
        }
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent event) {
        List blocks = event.blockList();
        blocks.removeIf(block -> {
            if (this.isDisarmedTripwire((Block)block)) {
                this.dropString((Block)block);
                return true;
            }
            return false;
        });
    }

    @EventHandler
    public void onEntityChange(EntityChangeBlockEvent event) {
        if (this.isDisarmedTripwire(event.getBlock())) {
            event.setCancelled(true);
            this.dropString(event.getBlock());
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.isDisarmedTripwire(block)) continue;
            event.setCancelled(true);
            this.dropString(block);
            break;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.isDisarmedTripwire(block)) continue;
            event.setCancelled(true);
            this.dropString(block);
            break;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("stringamount")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a7eCurrent string amount: \u00a7b" + this.stringAmount);
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage("\u00a7cUsage: /stringamount <number>");
                return true;
            }
            try {
                int value = Integer.parseInt(args[0]);
                if (value < 0) {
                    throw new NumberFormatException();
                }
                this.stringAmount = value;
                this.config.set("string-amount", (Object)value);
                this.configSave();
                sender.sendMessage("\u00a7aString amount set to \u00a7b" + value + "\u00a7a.");
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid number. Use a positive integer.");
            }
            return true;
        }
        if (label.equalsIgnoreCase("stringtoggle")) {
            this.dropEnabled = !this.dropEnabled;
            this.config.set("drop-enabled", (Object)this.dropEnabled);
            this.configSave();
            sender.sendMessage("\u00a7eString drop is now: " + (this.dropEnabled ? "\u00a7aENABLED" : "\u00a7cDISABLED"));
            return true;
        }
        return false;
    }

    private void configSave() {
        try {
            this.config.save(new File(this.getDataFolder(), "config.yml"));
        }
        catch (Exception e) {
            this.getLogger().warning("Could not save config: " + e.getMessage());
        }
    }
}

