/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.plugin.java.JavaPlugin;

public class ClearManager {
    private final JavaPlugin plugin;
    private List<EntityType> protectedMobs;
    private static final Set<Material> FARM_HINT_BLOCKS = new HashSet<Material>();

    private static void addIfExists(String name) {
        try {
            FARM_HINT_BLOCKS.add(Material.valueOf((String)name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ClearManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadProtectedMobs();
    }

    public void loadProtectedMobs() {
        this.protectedMobs = this.plugin.getConfig().getStringList("protected-mobs").stream().map(name -> {
            try {
                return EntityType.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid mob type in protected-mobs: " + name);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    public int clearEntities() {
        int removed = 0;
        List worlds = this.plugin.getConfig().getStringList("worlds");
        for (World w : Bukkit.getWorlds()) {
            if (!worlds.isEmpty() && !worlds.contains(w.getName())) continue;
            for (Entity e : w.getEntities()) {
                if (e instanceof Player || !this.shouldClear(e)) continue;
                e.remove();
                ++removed;
            }
        }
        return removed;
    }

    public int countClearableEntities() {
        int count = 0;
        List worlds = this.plugin.getConfig().getStringList("worlds");
        for (World w : Bukkit.getWorlds()) {
            if (!worlds.isEmpty() && !worlds.contains(w.getName())) continue;
            for (Entity e : w.getEntities()) {
                if (e instanceof Player || !this.shouldClear(e)) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean shouldClear(Entity e) {
        Tameable tame;
        if (e instanceof Item) {
            return true;
        }
        if (!(e instanceof LivingEntity)) {
            return false;
        }
        LivingEntity le = (LivingEntity)e;
        if (this.protectedMobs.contains(e.getType())) {
            return false;
        }
        if (e.getCustomName() != null) {
            return false;
        }
        if (le.getEquipment() != null && !le.getEquipment().getItemInMainHand().getType().isAir()) {
            return false;
        }
        if (this.isFarmAnimal(e.getType()) && this.isNearFarmBlocks(le, 6)) {
            return false;
        }
        return !(le instanceof Tameable) || !(tame = (Tameable)le).isTamed();
    }

    private boolean isFarmAnimal(EntityType type) {
        return switch (type) {
            case EntityType.PIG, EntityType.COW, EntityType.SHEEP, EntityType.CHICKEN, EntityType.RABBIT, EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.LLAMA, EntityType.GOAT, EntityType.TURTLE -> true;
            default -> false;
        };
    }

    private boolean isNearFarmBlocks(LivingEntity le, int radius) {
        Location loc = le.getLocation();
        World w = le.getWorld();
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        int r = Math.max(1, radius);
        for (int x = bx - r; x <= bx + r; ++x) {
            for (int y = by - 1; y <= by + 2; ++y) {
                for (int z = bz - r; z <= bz + r; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    Material m = b.getType();
                    if (!FARM_HINT_BLOCKS.contains(m) && !m.name().endsWith("_FENCE_GATE")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        ClearManager.addIfExists("OAK_FENCE");
        ClearManager.addIfExists("SPRUCE_FENCE");
        ClearManager.addIfExists("BIRCH_FENCE");
        ClearManager.addIfExists("JUNGLE_FENCE");
        ClearManager.addIfExists("ACACIA_FENCE");
        ClearManager.addIfExists("DARK_OAK_FENCE");
        ClearManager.addIfExists("NETHER_BRICK_FENCE");
        ClearManager.addIfExists("OAK_FENCE_GATE");
        ClearManager.addIfExists("SPRUCE_FENCE_GATE");
        ClearManager.addIfExists("BIRCH_FENCE_GATE");
        ClearManager.addIfExists("JUNGLE_FENCE_GATE");
        ClearManager.addIfExists("ACACIA_FENCE_GATE");
        ClearManager.addIfExists("DARK_OAK_FENCE_GATE");
        ClearManager.addIfExists("COBBLESTONE_WALL");
        ClearManager.addIfExists("MOSSY_COBBLESTONE_WALL");
        ClearManager.addIfExists("STONE_BRICK_WALL");
        ClearManager.addIfExists("HAY_BLOCK");
        ClearManager.addIfExists("MANGROVE_FENCE");
        ClearManager.addIfExists("BAMBOO_FENCE");
        ClearManager.addIfExists("MANGROVE_FENCE_GATE");
        ClearManager.addIfExists("BAMBOO_FENCE_GATE");
        ClearManager.addIfExists("CHERRY_FENCE");
        ClearManager.addIfExists("CHERRY_FENCE_GATE");
    }
}

