/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import com.girivardhan.epicclearlag.AutoClear;
import com.girivardhan.epicclearlag.ClearManager;
import com.girivardhan.epicclearlag.MessageUtil;
import com.girivardhan.epicclearlag.TPSMonitor;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandHandler
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final ClearManager clearManager;
    private final TPSMonitor tpsMonitor;
    private final AutoClear autoClear;
    private final MessageUtil msgUtil;

    public CommandHandler(JavaPlugin plugin, ClearManager clearManager, TPSMonitor tpsMonitor, AutoClear autoClear, MessageUtil msgUtil) {
        this.plugin = plugin;
        this.clearManager = clearManager;
        this.tpsMonitor = tpsMonitor;
        this.autoClear = autoClear;
        this.msgUtil = msgUtil;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("epicclearlag.admin")) {
            this.msgUtil.send(sender, "no-permission", Map.of());
            return true;
        }
        if (args.length == 0) {
            this.msgUtil.send(sender, "usage", Map.of("%prefix%", this.plugin.getConfig().getString("prefix", "")));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "now": {
                int removed = this.clearManager.clearEntities();
                this.msgUtil.broadcast("clear-now", Map.of("%removed%", String.valueOf(removed)));
                break;
            }
            case "status": {
                double tps = Bukkit.getServer().getTPS()[0];
                this.msgUtil.send(sender, "tps-status", Map.of("%tps%", String.format("%.2f", tps)));
                this.msgUtil.send(sender, "entities-status", Map.of("%count%", String.valueOf(this.clearManager.countClearableEntities())));
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.clearManager.loadProtectedMobs();
                this.msgUtil.send(sender, "reload", Map.of());
                break;
            }
            default: {
                this.msgUtil.send(sender, "unknown-command", Map.of("%prefix%", this.plugin.getConfig().getString("prefix", "")));
            }
        }
        return true;
    }
}

