/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import com.girivardhan.epicclearlag.ClearManager;
import com.girivardhan.epicclearlag.MessageUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPSMonitor {
    private final JavaPlugin plugin;
    private final ClearManager clearManager;
    private final MessageUtil msgUtil;

    public TPSMonitor(JavaPlugin plugin, ClearManager clearManager, MessageUtil msgUtil) {
        this.plugin = plugin;
        this.clearManager = clearManager;
        this.msgUtil = msgUtil;
    }

    public void start() {
        final double threshold = this.plugin.getConfig().getDouble("tps-monitor.threshold", 18.0);
        int interval = this.plugin.getConfig().getInt("tps-monitor.check-interval-seconds", 10);
        new BukkitRunnable(){

            public void run() {
                int removed;
                double tps = Bukkit.getServer().getTPS()[0];
                if (tps < threshold && (removed = TPSMonitor.this.clearManager.clearEntities()) > 0) {
                    Bukkit.getLogger().info("[EpicClearLag] TPS low (" + String.format("%.2f", tps) + ") \u2192 cleared " + removed + " entities.");
                    TPSMonitor.this.msgUtil.broadcast("clear-tps", Map.of("%removed%", String.valueOf(removed)));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L * (long)interval);
    }
}

