/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import com.girivardhan.epicclearlag.ClearManager;
import com.girivardhan.epicclearlag.MessageUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoClear {
    private final JavaPlugin plugin;
    private final ClearManager clearManager;
    private final MessageUtil msgUtil;

    public AutoClear(JavaPlugin plugin, ClearManager clearManager, MessageUtil msgUtil) {
        this.plugin = plugin;
        this.clearManager = clearManager;
        this.msgUtil = msgUtil;
    }

    public void start() {
        int intervalMinutes = this.plugin.getConfig().getInt("autoclear.interval-minutes", 6);
        new BukkitRunnable(){

            public void run() {
                AutoClear.this.startCountdown();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L * (long)intervalMinutes);
    }

    private void startCountdown() {
        final int countdownSeconds = this.plugin.getConfig().getInt("autoclear.countdown-seconds", 60);
        final String titleConfig = this.plugin.getConfig().getString("autoclear.titles.countdown.title", "&cAuto Clear!");
        final String subtitleConfig = this.plugin.getConfig().getString("autoclear.titles.countdown.subtitle", "&eStarting in &6%time% &eseconds!");
        final int fadeIn = this.plugin.getConfig().getInt("autoclear.titles.countdown.fade-in", 0);
        final int stay = this.plugin.getConfig().getInt("autoclear.titles.countdown.stay", 20);
        final int fadeOut = this.plugin.getConfig().getInt("autoclear.titles.countdown.fade-out", 0);
        new BukkitRunnable(){
            int time;
            {
                this.time = countdownSeconds;
            }

            public void run() {
                if (this.time <= 0) {
                    int removed = AutoClear.this.clearManager.clearEntities();
                    AutoClear.this.msgUtil.broadcast("clear-done", Map.of("%removed%", String.valueOf(removed)));
                    AutoClear.this.playSoundForAll(AutoClear.this.plugin.getConfig().getString("autoclear.sounds.cleared", "ENTITY_EXPERIENCE_ORB_PICKUP"));
                    this.cancel();
                } else if (this.time <= 5 || this.time % 5 == 0) {
                    AutoClear.this.msgUtil.broadcast("clear-start", Map.of("%time%", String.valueOf(this.time)));
                    String subtitle = subtitleConfig.replace("%time%", String.valueOf(this.time));
                    AutoClear.this.msgUtil.broadcastTitle(titleConfig, subtitle, fadeIn, stay, fadeOut);
                    AutoClear.this.playCountdownSound(this.time);
                }
                --this.time;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void playCountdownSound(int time) {
        String soundName = this.plugin.getConfig().getString("autoclear.sounds.countdown", "BLOCK_NOTE_BLOCK_PLING");
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.valueOf((String)soundName), 1.0f, 1.0f);
        }
    }

    private void playSoundForAll(String soundName) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.valueOf((String)soundName), 1.0f, 1.0f);
        }
    }
}

