/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.Yaml;

public class AutoUpdater {
    private final JavaPlugin plugin;
    private final String downloadUrl;

    public AutoUpdater(JavaPlugin plugin, String downloadUrl) {
        this.plugin = plugin;
        this.downloadUrl = downloadUrl;
    }

    public void update() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                File pluginsDir = this.plugin.getDataFolder().getParentFile();
                File tempFile = new File(pluginsDir, this.plugin.getDescription().getName() + "_new.jar");
                URL url = new URL(this.downloadUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (InputStream in = connection.getInputStream();
                     File[] out = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                this.plugin.getLogger().info("[EpicClearLag] Update downloaded successfully!");
                File[] jars = pluginsDir.listFiles((dir, name) -> name.endsWith(".jar"));
                if (jars != null) {
                    for (File jar : jars) {
                        if (jar.equals(tempFile) || !this.isPluginJar(jar, this.plugin.getDescription().getName())) continue;
                        this.plugin.getLogger().info("[EpicClearLag] Deleting old jar: " + jar.getName());
                        jar.delete();
                    }
                }
                File finalJar = new File(pluginsDir, this.plugin.getDescription().getName() + ".jar");
                try {
                    Files.move(tempFile.toPath(), finalJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.plugin.getLogger().info("[EpicClearLag] New jar applied successfully! Restart server to activate.");
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("[EpicClearLag] Failed to rename new jar to final file: " + e.getMessage());
                    this.plugin.getLogger().warning("[EpicClearLag] Keep the " + tempFile.getName() + " file and rename it manually.");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[EpicClearLag] Failed to auto-update: " + e.getMessage());
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isPluginJar(File jarFile, String pluginName) {
        block13: {
            try (JarFile jar = new JarFile(jarFile);){
                boolean bl;
                block14: {
                    JarEntry entry = jar.getJarEntry("plugin.yml");
                    if (entry == null) break block13;
                    InputStream in = jar.getInputStream(entry);
                    try {
                        Yaml yaml = new Yaml();
                        Map data = (Map)yaml.load(in);
                        String name = (String)data.get("name");
                        bl = pluginName.equals(name);
                        if (in == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return bl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

