/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClearManager {
    private final JavaPlugin plugin;
    private List<EntityType> protectedMobs;
    private static final Set<Material> FARM_HINT_BLOCKS;
    private static final String PLAYER_PLACED_KEY = "PLAYER_PLACED";

    public ClearManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadProtectedMobs();
    }

    public void loadProtectedMobs() {
        this.protectedMobs = this.plugin.getConfig().getStringList("protected-mobs").stream().map(name -> {
            try {
                return EntityType.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid mob type in protected-mobs: " + name);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    public int clearEntities() {
        int removed = 0;
        List worlds = this.plugin.getConfig().getStringList("worlds");
        for (World w : Bukkit.getWorlds()) {
            if (!worlds.isEmpty() && !worlds.contains(w.getName())) continue;
            for (Entity e : w.getEntities()) {
                if (!(e instanceof LivingEntity) && !(e instanceof Item) || e instanceof Player || !this.shouldClear(e)) continue;
                e.remove();
                ++removed;
            }
        }
        return removed;
    }

    public int countClearableEntities() {
        int count = 0;
        List worlds = this.plugin.getConfig().getStringList("worlds");
        for (World w : Bukkit.getWorlds()) {
            if (!worlds.isEmpty() && !worlds.contains(w.getName())) continue;
            for (Entity e : w.getEntities()) {
                if (!(e instanceof LivingEntity) && !(e instanceof Item) || e instanceof Player || !this.shouldClear(e)) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean shouldClear(Entity e) {
        if (e instanceof Item) {
            return true;
        }
        if (e instanceof LivingEntity) {
            Tameable tame;
            LivingEntity le = (LivingEntity)e;
            if (this.protectedMobs.contains(e.getType())) {
                return false;
            }
            if (e.getCustomName() != null) {
                return false;
            }
            if (le.getEquipment() != null && !le.getEquipment().getItemInMainHand().getType().isAir()) {
                return false;
            }
            if (le instanceof Tameable && (tame = (Tameable)le).isTamed()) {
                return false;
            }
            return !this.isFarmAnimal(e.getType()) || !this.isNearFarmBlocksOrPlayerBlocks(le, 6);
        }
        return false;
    }

    private boolean isFarmAnimal(EntityType type) {
        return switch (type) {
            case EntityType.PIG, EntityType.COW, EntityType.SHEEP, EntityType.CHICKEN, EntityType.RABBIT, EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.LLAMA, EntityType.GOAT, EntityType.TURTLE -> true;
            default -> false;
        };
    }

    private boolean isNearFarmBlocksOrPlayerBlocks(LivingEntity le, int radius) {
        Location loc = le.getLocation();
        World w = le.getWorld();
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        int r = Math.max(1, radius);
        for (int x = bx - r; x <= bx + r; ++x) {
            for (int y = by - 1; y <= by + 2; ++y) {
                for (int z = bz - r; z <= bz + r; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    Material m = b.getType();
                    if (FARM_HINT_BLOCKS.contains(m) || m.name().endsWith("_FENCE_GATE")) {
                        return true;
                    }
                    if (!b.hasMetadata(PLAYER_PLACED_KEY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void markPlayerPlacedBlock(Block block) {
        block.setMetadata(PLAYER_PLACED_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    static {
        String[] blocks;
        FARM_HINT_BLOCKS = new HashSet<Material>();
        for (String b : blocks = new String[]{"OAK_FENCE", "SPRUCE_FENCE", "BIRCH_FENCE", "JUNGLE_FENCE", "ACACIA_FENCE", "DARK_OAK_FENCE", "MANGROVE_FENCE", "BAMBOO_FENCE", "CHERRY_FENCE", "OAK_FENCE_GATE", "SPRUCE_FENCE_GATE", "BIRCH_FENCE_GATE", "JUNGLE_FENCE_GATE", "ACACIA_FENCE_GATE", "DARK_OAK_FENCE_GATE", "MANGROVE_FENCE_GATE", "BAMBOO_FENCE_GATE", "CHERRY_FENCE_GATE", "COBBLESTONE_WALL", "MOSSY_COBBLESTONE_WALL", "STONE_BRICK_WALL", "NETHER_BRICK_FENCE", "HAY_BLOCK"}) {
            try {
                FARM_HINT_BLOCKS.add(Material.valueOf((String)b));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

