/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import com.girivardhan.epicclearlag.AutoClear;
import com.girivardhan.epicclearlag.AutoUpdater;
import com.girivardhan.epicclearlag.ClearManager;
import com.girivardhan.epicclearlag.CommandHandler;
import com.girivardhan.epicclearlag.EpicClearLagTabCompleter;
import com.girivardhan.epicclearlag.MessageUtil;
import com.girivardhan.epicclearlag.TPSMonitor;
import com.girivardhan.epicclearlag.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EpicClearLag
extends JavaPlugin {
    private ClearManager clearManager;
    private TPSMonitor tpsMonitor;
    private AutoClear autoClear;
    private MessageUtil msgUtil;

    public void onEnable() {
        this.saveDefaultConfig();
        this.msgUtil = new MessageUtil(this);
        this.clearManager = new ClearManager(this);
        this.tpsMonitor = new TPSMonitor(this, this.clearManager, this.msgUtil);
        this.autoClear = new AutoClear(this, this.clearManager, this.msgUtil);
        if (this.getConfig().getBoolean("autoclear.enabled", true)) {
            this.autoClear.start();
        }
        if (this.getConfig().getBoolean("tps-monitor.enabled", true)) {
            this.tpsMonitor.start();
        }
        this.getCommand("epicclearlag").setExecutor((CommandExecutor)new CommandHandler(this, this.clearManager, this.tpsMonitor, this.autoClear, this.msgUtil));
        this.getCommand("epicclearlag").setTabCompleter((TabCompleter)new EpicClearLagTabCompleter());
        this.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onBlockPlace(BlockPlaceEvent e) {
                EpicClearLag.this.clearManager.markPlayerPlacedBlock(e.getBlock());
            }
        }, (Plugin)this);
        this.printStartupMessage();
        String versionUrl = "https://raw.githubusercontent.com/epicshulker/version/main/version.txt";
        String jarUrl = "https://raw.githubusercontent.com/epicshulker/version/refs/heads/main/EpicClearLag-1.0.0.3-GV-333-CL1.jar";
        new UpdateChecker(this, versionUrl).checkForUpdates((isUpdateAvailable, latestVersion) -> {
            if (isUpdateAvailable.booleanValue()) {
                this.getLogger().warning("------------------------------------------------------------");
                this.getLogger().warning(" A new version of EpicClearLag is available!");
                this.getLogger().warning(" Current: " + this.getDescription().getVersion() + " | Latest: " + latestVersion);
                this.getLogger().warning(" Downloading update automatically...");
                this.getLogger().warning("------------------------------------------------------------");
                new AutoUpdater(this, jarUrl).update();
            } else {
                this.getLogger().info("You are running the latest version of EpicClearLag!");
            }
        });
    }

    public void onDisable() {
        this.printShutdownMessage();
    }

    private void printStartupMessage() {
        this.getLogger().info("------------------------------------------------------------");
        this.getLogger().info(" EpicClearLag Plugin Loaded Successfully!");
        this.getLogger().info(" Version: " + this.getDescription().getVersion());
        this.getLogger().info(" Developed by: BHOJARAJU GIRIVARDHAN");
        this.getLogger().info(" Spigot/PaperMC Support: 1.17 - Latest");
        this.getLogger().info("------------------------------------------------------------");
    }

    private void printShutdownMessage() {
        this.getLogger().info("------------------------------------------------------------");
        this.getLogger().info(" EpicClearLag Plugin Unloaded Successfully [Disabled]");
        this.getLogger().info(" Version: " + this.getDescription().getVersion());
        this.getLogger().info("------------------------------------------------------------");
    }
}

