/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageUtil {
    private final JavaPlugin plugin;

    public MessageUtil(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void broadcast(String path, Map<String, String> placeholders) {
        String msg = this.plugin.getConfig().getString("messages." + path, "");
        if (msg != null && !msg.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace(entry.getKey(), entry.getValue());
            }
            msg = msg.replace("%prefix%", this.plugin.getConfig().getString("prefix", ""));
            msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
            Bukkit.broadcastMessage((String)msg);
        }
    }

    public void send(CommandSender sender, String path, Map<String, String> placeholders) {
        String msg = this.plugin.getConfig().getString("messages." + path, "");
        if (msg != null && !msg.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace(entry.getKey(), entry.getValue());
            }
            msg = msg.replace("%prefix%", this.plugin.getConfig().getString("prefix", ""));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        }
    }

    public void broadcastTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
        }
    }

    public void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }
}

