/*
 * Decompiled with CFR 0.152.
 */
package com.girivardhan.epicclearlag;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String versionUrl;

    public UpdateChecker(JavaPlugin plugin, String versionUrl) {
        this.plugin = plugin;
        this.versionUrl = versionUrl;
    }

    public void checkForUpdates(BiConsumer<Boolean, String> callback) {
        CompletableFuture.runAsync(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.versionUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String latestVersion = reader.readLine().trim();
                    String currentVersion = this.plugin.getDescription().getVersion();
                    boolean updateAvailable = !latestVersion.equalsIgnoreCase(currentVersion);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(updateAvailable, latestVersion));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
            }
        });
    }
}

