/*
 * Decompiled with CFR 0.152.
 */
package kimiram.notes.client.gui.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kimiram.notes.Image;
import kimiram.notes.client.NotesClient;
import kimiram.notes.client.gui.cursor.StandardCursors;
import kimiram.notes.client.gui.screen.AddImageScreen;
import kimiram.notes.client.gui.widget.ImageWidget;
import kimiram.notes.client.networking.payload.FinalizeNoteC2SPayload;
import kimiram.notes.client.networking.payload.SaveNoteC2SPayload;
import kimiram.notes.items.ModComponents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_8710;

public class NoteScreen
extends class_437 {
    public final int MAX_LINE_WIDTH = 120;
    public final int MAX_TEXT_HEIGHT = 156;
    public int X_OFFSET;
    public int Y_OFFSET = 22;
    private String text;
    private List<Image> images;
    private List<ImageWidget> imageWidgets = new ArrayList<ImageWidget>();
    private final class_3728 selectionManager = new class_3728(this::getText, this::setText, this::getClipboard, this::setClipboard, text -> this.field_22793.method_1713(text, 120) <= 156);
    private List<Line> lines;
    private class_1799 stack;
    private int ticks = 0;
    private long lastClickTime = 0L;
    private int lastClickInd = -1;
    private boolean mouseOverImage = false;

    public NoteScreen(class_1799 stack) {
        super((class_2561)class_2561.method_43470((String)"Note Screen"));
        ModComponents.NoteComponent content = (ModComponents.NoteComponent)stack.method_58695(ModComponents.NOTE_COMPONENT_TYPE, (Object)new ModComponents.NoteComponent("", Collections.emptyList()));
        this.text = content.text();
        this.images = content.images();
        this.stack = stack;
    }

    public void method_25419() {
        this.updateImagesList();
        ModComponents.NoteComponent content = new ModComponents.NoteComponent(this.text, this.images);
        this.stack.method_57379(ModComponents.NOTE_COMPONENT_TYPE, (Object)content);
        ClientPlayNetworking.send((class_8710)new SaveNoteC2SPayload(this.stack));
        StandardCursors.ARROW.applyTo(class_310.method_1551().method_22683());
        class_310.method_1551().method_1507(null);
    }

    public void openAddImageScreen() {
        this.updateImagesList();
        class_310.method_1551().method_1507((class_437)new AddImageScreen(this));
    }

    public void finalizeNote() {
        this.updateImagesList();
        ModComponents.NoteComponent content = new ModComponents.NoteComponent(this.text, this.images);
        this.stack.method_57379(ModComponents.NOTE_COMPONENT_TYPE, (Object)content);
        ClientPlayNetworking.send((class_8710)new FinalizeNoteC2SPayload(this.stack));
        StandardCursors.ARROW.applyTo(class_310.method_1551().method_22683());
        class_310.method_1551().method_1507(null);
    }

    public void updateImagesList() {
        this.images = new ArrayList<Image>();
        for (ImageWidget widget : this.imageWidgets) {
            if (!widget.field_22763 || !widget.field_22764) continue;
            this.images.add(new Image(widget.getImageURL(), widget.method_46426() - this.X_OFFSET, widget.method_46427() - this.Y_OFFSET, widget.method_25368(), widget.method_25364()));
        }
    }

    public void addImage(Image newImage) {
        this.images.add(newImage);
        this.imageWidgets.add(new ImageWidget(newImage, this));
        this.method_41843();
    }

    public String getText() {
        return this.text != null ? this.text : "";
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public void setClipboard(String clipboard) {
        if (this.field_22787 != null) {
            class_3728.method_27551((class_310)this.field_22787, (String)clipboard);
        }
    }

    public String getClipboard() {
        return this.field_22787 != null ? class_3728.method_27556((class_310)this.field_22787) : "";
    }

    public void updateLines() {
        this.lines = new ArrayList<Line>();
        this.field_22793.method_27527().method_27485(this.text, 120, class_2583.field_24360, false, (stylex, start, end) -> this.lines.add(new Line(this.text.substring(start, end), start, end)));
        if (this.text.endsWith("\n")) {
            this.lines.add(new Line("", this.text.length(), this.text.length()));
        }
        if (this.text.isEmpty()) {
            this.lines.add(new Line("", 0, 0));
        }
    }

    public void method_25393() {
        super.method_25393();
        ++this.ticks;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.selectionManager.method_27563();
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            this.selectionManager.method_27559();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.selectionManager.method_27554();
            this.updateLines();
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            this.selectionManager.method_27547();
            this.updateLines();
            return true;
        }
        class_3728.class_7279 selectionType = NoteScreen.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        int s = this.selectionManager.method_16201();
        switch (keyCode) {
            case 259: {
                this.selectionManager.method_42574(-1, selectionType);
                this.updateLines();
                return true;
            }
            case 261: {
                this.selectionManager.method_42574(1, selectionType);
                this.updateLines();
                return true;
            }
            case 257: 
            case 335: {
                if (this.lines.size() < 17) {
                    this.selectionManager.method_16197("\n");
                    this.updateLines();
                    return true;
                }
                return false;
            }
            case 263: {
                this.selectionManager.method_42575(-1, class_437.method_25442(), selectionType);
                return true;
            }
            case 262: {
                this.selectionManager.method_42575(1, class_437.method_25442(), selectionType);
                return true;
            }
            case 265: {
                if (this.getLineIndex(this.selectionManager.method_16201()) == 0) {
                    this.selectionManager.method_27553(NoteScreen.method_25442());
                } else {
                    this.moveVertically(s, -1);
                }
                return true;
            }
            case 264: {
                if (this.getLineIndex(this.selectionManager.method_16201()) == this.lines.size() - 1) {
                    this.selectionManager.method_27558(NoteScreen.method_25442());
                } else {
                    this.moveVertically(s, 1);
                }
                return true;
            }
            case 268: {
                if (NoteScreen.method_25441()) {
                    this.selectionManager.method_27553(NoteScreen.method_25442());
                } else {
                    int ind = this.getLineIndex(s);
                    this.selectionManager.method_27560(this.lines.get((int)ind).start, NoteScreen.method_25442());
                }
                return true;
            }
            case 269: {
                if (NoteScreen.method_25441()) {
                    this.selectionManager.method_27558(NoteScreen.method_25442());
                } else {
                    int ind = this.getLineIndex(s);
                    this.selectionManager.method_27560(this.lines.get((int)ind).end, NoteScreen.method_25442());
                }
                return true;
            }
        }
        return false;
    }

    private void moveVertically(int pos, int lines) {
        int i = this.getLineIndex(pos);
        int j = i + lines;
        int k = pos - this.lines.get((int)i).start;
        int l = this.lines.get((int)j).text.length();
        int m = this.lines.get((int)j).start + Math.min(k, l);
        this.selectionManager.method_27560(m, NoteScreen.method_25442());
    }

    public boolean method_25400(char chr, int modifiers) {
        if (class_3544.method_57175((char)chr)) {
            this.selectionManager.method_16199(chr);
            this.updateLines();
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    protected void method_25426() {
        this.updateLines();
        this.X_OFFSET = (this.field_22789 - 128) / 2 + 4;
        for (Image image : this.images) {
            ImageWidget imageWidget = new ImageWidget(image, this);
            this.imageWidgets.add(imageWidget);
            this.method_37063((class_364)imageWidget);
        }
        class_4185 addImageButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.notes.add_image"), button -> this.openAddImageScreen()).method_46431();
        addImageButton.method_55444(170, 20, this.field_22789 / 2 - 80 - 5, 190);
        this.method_37063((class_364)addImageButton);
        class_4185 finalizeNoteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.notes.finalize"), button -> this.finalizeNote()).method_46431();
        finalizeNoteButton.method_55444(80, 20, this.field_22789 / 2 - 80 - 5, 215);
        this.method_37063((class_364)finalizeNoteButton);
        class_4185 doneButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46431();
        doneButton.method_55444(80, 20, this.field_22789 / 2 + 5, 215);
        this.method_37063((class_364)doneButton);
    }

    protected void method_41843() {
        this.updateImagesList();
        this.imageWidgets.clear();
        super.method_41843();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int e;
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        for (int i = 0; i < this.lines.size(); ++i) {
            context.method_51433(this.field_22793, this.lines.get((int)i).text, this.X_OFFSET, this.Y_OFFSET + i * 9, -16777216, false);
        }
        int s = this.selectionManager.method_16201();
        if (s != (e = this.selectionManager.method_16203())) {
            this.drawSelections(context);
        }
        this.drawCursor(context, this.getCursorPos(), s == this.text.length());
        for (int i = this.imageWidgets.size() - 1; i >= 0; --i) {
            ImageWidget widget = this.imageWidgets.get(i);
            if (!widget.field_22763 || !widget.field_22764) continue;
            widget.renderImage(context);
        }
        if (!NotesClient.holdingAnyImage) {
            this.mouseOverImage = false;
            for (ImageWidget widget : this.imageWidgets) {
                if (!widget.field_22763 || !widget.field_22764) continue;
                widget.changeCursor(mouseX, mouseY, this.mouseOverImage);
                if (!widget.method_25405(mouseX, mouseY)) continue;
                this.mouseOverImage = true;
            }
            this.changeCursor(mouseX, mouseY);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25420(context, mouseX, mouseY, deltaTicks);
        context.method_25302(class_1921::method_62277, class_2960.method_60655((String)"notes", (String)"textures/gui/note.png"), (this.field_22789 - 128) / 2 - 16, 12, 0.0f, 0.0f, 256, 256, 256, 256, 256, 256);
    }

    private void changeCursor(int mouseX, int mouseY) {
        if (!this.mouseOverImage) {
            if (this.isMouseOverNote(mouseX, mouseY)) {
                if (NotesClient.currentCursor != "ibeam") {
                    StandardCursors.IBEAM.applyTo(class_310.method_1551().method_22683());
                    NotesClient.currentCursor = "ibeam";
                }
            } else if (NotesClient.currentCursor != "arrow") {
                StandardCursors.ARROW.applyTo(class_310.method_1551().method_22683());
                NotesClient.currentCursor = "arrow";
            }
        }
    }

    public boolean isMouseOverNote(int mouseX, int mouseY) {
        return mouseX >= this.X_OFFSET && mouseX <= this.X_OFFSET + 120 && mouseY >= this.Y_OFFSET && mouseY <= this.Y_OFFSET + 156;
    }

    private void drawSelections(class_332 context) {
        int x2;
        int s = this.selectionManager.method_16201();
        int e = this.selectionManager.method_16203();
        int i = Math.min(s, e);
        int j = Math.max(s, e);
        int l = this.getLineIndex(i);
        int r = this.getLineIndex(j);
        class_5225 textHandler = this.field_22793.method_27527();
        int x1 = this.X_OFFSET + (int)textHandler.method_27482(this.text.substring(this.lines.get((int)l).start, i));
        int y1 = this.Y_OFFSET + l * 9;
        int y2 = y1 + 9;
        if (l != r) {
            x2 = this.X_OFFSET + 120;
            context.method_51739(class_1921.method_51786(), x1, y1, x2, y2, -16776961);
            x1 = this.X_OFFSET;
            context.method_51739(class_1921.method_51786(), x1, y1 += 9, x2, y2 += 9 * (r - l - 1), -16776961);
            y1 = y2;
            y2 += 9;
            x2 = x1 + (int)textHandler.method_27482(this.text.substring(this.lines.get((int)r).start, j));
        } else {
            x2 = x1 + (int)textHandler.method_27482(this.text.substring(i, j));
        }
        context.method_51739(class_1921.method_51786(), x1, y1, x2, y2, -16776961);
    }

    private void drawCursor(class_332 context, Position pos, boolean atEnd) {
        int x = pos.x;
        int y = pos.y;
        if (this.ticks / 6 % 2 == 0) {
            if (atEnd) {
                context.method_51433(this.field_22793, "_", x, y, -16777216, false);
            } else {
                context.method_25294(x - 1, y - 1, x, y + 9, -16777216);
            }
        }
    }

    private Position getCursorPos() {
        int x = 0;
        int y = 0;
        int i = 0;
        int s = this.selectionManager.method_16201();
        if (!this.text.isEmpty()) {
            i = this.getLineIndex(s);
            x = this.field_22793.method_1727(this.text.substring(this.lines.get((int)i).start, s));
            y = i * 9;
        }
        return new Position(this.X_OFFSET + x, this.Y_OFFSET + y);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.mouseOverImage && button == 0) {
            long l = class_156.method_658();
            int i = this.getPositionAt((int)mouseX, (int)mouseY);
            if (i >= 0) {
                if (i != this.lastClickInd || l - this.lastClickTime > 250L) {
                    this.selectionManager.method_27560(i, NoteScreen.method_25442());
                } else if (!this.selectionManager.method_27568()) {
                    this.selectionManager.method_27548(class_5225.method_27483((String)this.text, (int)-1, (int)i, (boolean)false), class_5225.method_27483((String)this.text, (int)1, (int)i, (boolean)false));
                } else {
                    this.selectionManager.method_27563();
                }
            }
            this.lastClickTime = l;
            this.lastClickInd = i;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i;
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (!this.mouseOverImage && button == 0 && (i = this.getPositionAt((int)mouseX, (int)mouseY)) != -1) {
            this.selectionManager.method_27560(i, true);
            return true;
        }
        return false;
    }

    private int getPositionAt(int x, int y) {
        if ((x -= this.X_OFFSET - 4) > 0 && x < 128 && (y -= this.Y_OFFSET) > 0) {
            if (y < this.lines.size() * 9) {
                int i;
                int l = y / 9;
                Line line = this.lines.get(l);
                if (x >= this.field_22793.method_1727(line.text)) {
                    return line.end;
                }
                for (i = 0; i < line.text.length() && this.field_22793.method_1727(line.text.substring(0, i)) <= x; ++i) {
                }
                return line.start + i - 1;
            }
            if (y < 156) {
                return this.text.length();
            }
        }
        return -1;
    }

    private int getLineIndex(int pos) {
        int l = 0;
        int r = this.lines.size();
        while (r - l > 1) {
            int m = (l + r) / 2;
            if (this.lines.get((int)m).start > pos) {
                r = m;
                continue;
            }
            l = m;
        }
        return l;
    }

    static class Line {
        public String text;
        public int start;
        public int end;

        public Line(String text, int start, int end) {
            this.text = text;
            this.start = start;
            this.end = end;
        }
    }

    record Position(int x, int y) {
    }
}

