/*
 * Decompiled with CFR 0.152.
 */
package kimiram.notes.client.gui.widget;

import kimiram.notes.Image;
import kimiram.notes.client.NotesClient;
import kimiram.notes.client.gui.cursor.StandardCursors;
import kimiram.notes.client.gui.screen.NoteScreen;
import kimiram.notes.client.util.ImageHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class ImageWidget
extends class_339 {
    private double dx;
    private double dy;
    private double dwidth;
    private double dheight;
    private final String stringURL;
    private NoteScreen screen;
    private boolean changingSize = false;
    private String xside = "none";
    private String yside = "none";
    private boolean holding = false;

    public ImageWidget(Image image, NoteScreen screen) {
        super(image.x() + screen.X_OFFSET, image.y() + screen.Y_OFFSET, image.width(), image.height(), (class_2561)class_2561.method_43473());
        this.dx = image.x() + screen.X_OFFSET;
        this.dy = image.y() + screen.Y_OFFSET;
        this.dwidth = image.width();
        this.dheight = image.height();
        this.stringURL = image.url();
        this.screen = screen;
        if (!ImageHelper.loadingImages.containsKey(image.url()) && !ImageHelper.loadedImages.containsKey(image.url())) {
            ImageHelper.downloadImage(image.url());
        }
    }

    public boolean isHolding() {
        return this.holding;
    }

    public String getImageURL() {
        return this.stringURL;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        ImageHelper.updateImage(this.stringURL);
    }

    public void renderImage(class_332 context) {
        if (this.method_25367()) {
            context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 0x5F5F5F5F);
        }
        if (ImageHelper.loadedImages.containsKey(this.stringURL)) {
            context.method_25302(class_1921::method_62277, (class_2960)ImageHelper.loadedImages.get(this.stringURL).getA(), this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
        } else {
            context.method_25302(class_1921::method_62277, ImageHelper.defaultImageID, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
        }
    }

    public void changeCursor(int mouseX, int mouseY, boolean overAnotherImage) {
        if (!overAnotherImage) {
            class_1041 window = class_310.method_1551().method_22683();
            if ((this.isLeftBorder(mouseX, mouseY) || this.isRightBorder(mouseX, mouseY)) && !this.isBottomBorder(mouseX, mouseY) && !this.isTopBorder(mouseX, mouseY)) {
                if (NotesClient.currentCursor != "resize_ew") {
                    StandardCursors.RESIZE_EW.applyTo(window);
                    NotesClient.currentCursor = "resize_ew";
                }
            } else if ((this.isTopBorder(mouseX, mouseY) || this.isBottomBorder(mouseX, mouseY)) && !this.isLeftBorder(mouseX, mouseY) && !this.isRightBorder(mouseX, mouseY)) {
                if (NotesClient.currentCursor != "resize_ns") {
                    StandardCursors.RESIZE_NS.applyTo(window);
                    NotesClient.currentCursor = "resize_ns";
                }
            } else if (this.isLeftBorder(mouseX, mouseY) && this.isTopBorder(mouseX, mouseY) || this.isRightBorder(mouseX, mouseY) && this.isBottomBorder(mouseX, mouseY)) {
                if (NotesClient.currentCursor != "resize_nwse") {
                    StandardCursors.RESIZE_NWSE.applyTo(window);
                    NotesClient.currentCursor = "resize_nwse";
                }
            } else if (this.isRightBorder(mouseX, mouseY) && this.isTopBorder(mouseX, mouseY) || this.isLeftBorder(mouseX, mouseY) && this.isBottomBorder(mouseX, mouseY)) {
                if (NotesClient.currentCursor != "resize_nesw") {
                    StandardCursors.RESIZE_NESW.applyTo(window);
                    NotesClient.currentCursor = "resize_nesw";
                }
            } else if (NotesClient.currentCursor != "arrow") {
                StandardCursors.ARROW.applyTo(window);
                NotesClient.currentCursor = "arrow";
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.field_22764 = false;
            this.field_22763 = false;
            ImageWidget.method_62888((class_1144)class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    public void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.changingSize) {
            if (this.xside == "left" && this.dwidth - deltaX >= 5.0 && this.method_46426() + this.field_22758 - (int)(this.dwidth - deltaX) >= this.screen.X_OFFSET) {
                this.dwidth -= deltaX;
                this.dx = this.method_46426() + this.field_22758 - (int)this.dwidth;
            }
            if (this.yside == "top" && this.dheight - deltaY >= 5.0 && this.method_46427() + this.field_22759 - (int)(this.dheight - deltaY) >= this.screen.Y_OFFSET) {
                this.dheight -= deltaY;
                this.dy = this.method_46427() + this.field_22759 - (int)this.dheight;
            }
            if (this.xside == "right" && this.method_46426() + (int)(this.dwidth + deltaX) <= this.screen.X_OFFSET + this.screen.MAX_LINE_WIDTH) {
                this.dwidth = Math.max(this.dwidth + deltaX, 5.0);
            }
            if (this.yside == "bottom" && this.method_46427() + (int)(this.dheight + deltaY) <= this.screen.Y_OFFSET + this.screen.MAX_TEXT_HEIGHT) {
                this.dheight = Math.max(this.dheight + deltaY, 3.0);
            }
            this.method_55444((int)this.dwidth, (int)this.dheight, (int)this.dx, (int)this.dy);
        } else {
            if ((int)(this.dx + deltaX) >= this.screen.X_OFFSET && (int)(this.dx + deltaX) + this.field_22758 <= this.screen.X_OFFSET + this.screen.MAX_LINE_WIDTH) {
                this.dx += deltaX;
            }
            if ((int)(this.dy + deltaY) >= this.screen.Y_OFFSET && (int)(this.dy + deltaY) + this.field_22759 <= this.screen.Y_OFFSET + this.screen.MAX_TEXT_HEIGHT) {
                this.dy += deltaY;
            }
            this.method_48229((int)this.dx, (int)this.dy);
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.isLeftBorder(mx, my)) {
            this.xside = "left";
            this.changingSize = true;
        }
        if (this.isTopBorder(mx, my)) {
            this.yside = "top";
            this.changingSize = true;
        }
        if (this.isRightBorder(mx, my)) {
            this.xside = "right";
            this.changingSize = true;
        }
        if (this.isBottomBorder(mx, my)) {
            this.yside = "bottom";
            this.changingSize = true;
        }
        this.holding = true;
        NotesClient.holdingAnyImage = true;
    }

    public void method_25357(double mouseX, double mouseY) {
        this.changingSize = false;
        this.xside = "none";
        this.yside = "none";
        this.holding = false;
        NotesClient.holdingAnyImage = false;
    }

    private boolean isLeftBorder(int x, int y) {
        int wx = this.method_46426();
        int wy = this.method_46427();
        return x >= wx && x <= wx + 3 && y >= wy && y <= wy + this.field_22759;
    }

    private boolean isRightBorder(int x, int y) {
        int wx = this.method_46426();
        int wy = this.method_46427();
        return x <= wx + this.field_22758 && x >= wx + this.field_22758 - 3 && y >= wy && y <= wy + this.field_22759;
    }

    private boolean isTopBorder(int x, int y) {
        int wx = this.method_46426();
        int wy = this.method_46427();
        return y >= wy && y <= wy + 3 && x >= wx && x <= wx + this.field_22758;
    }

    private boolean isBottomBorder(int x, int y) {
        int wx = this.method_46426();
        int wy = this.method_46427();
        return y <= wy + this.field_22759 && y >= wy + this.field_22759 - 3 && x >= wx && x <= wx + this.field_22758;
    }

    protected void method_47399(class_6382 builder) {
    }

    public void method_25354(class_1144 soundManager) {
    }
}

