/*
 * Decompiled with CFR 0.152.
 */
package kimiram.notes.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import kimiram.notes.Image;
import kimiram.notes.client.NotesClient;
import kimiram.notes.client.gui.screen.AddImageScreen;
import kimiram.notes.client.gui.widget.ImageWidget;
import kimiram.notes.client.networking.payload.FinalizeNoteC2SPayload;
import kimiram.notes.client.networking.payload.SaveNoteC2SPayload;
import kimiram.notes.items.ModComponents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7529;
import net.minecraft.class_8710;

public class NoteScreen
extends class_437 {
    public final int MAX_LINE_WIDTH = 120;
    public final int MAX_TEXT_HEIGHT = 156;
    public int X_OFFSET;
    public int Y_OFFSET = 22;
    private class_7529 editBox;
    private class_1799 stack;
    private String text = "";
    private List<Image> images = new ArrayList<Image>();
    private List<ImageWidget> imageWidgets = new ArrayList<ImageWidget>();

    public NoteScreen(class_1799 stack) {
        super((class_2561)class_2561.method_43470((String)"Note Screen"));
        this.stack = stack;
        ModComponents.NoteComponent content = (ModComponents.NoteComponent)stack.method_58694(ModComponents.NOTE_COMPONENT_TYPE);
        if (content != null) {
            this.text = content.text();
            this.images = content.images();
        }
    }

    public void method_25419() {
        this.updateImagesList();
        ModComponents.NoteComponent content = new ModComponents.NoteComponent(this.text, this.images);
        this.stack.method_57379(ModComponents.NOTE_COMPONENT_TYPE, (Object)content);
        ClientPlayNetworking.send((class_8710)new SaveNoteC2SPayload(this.stack));
        class_310.method_1551().method_1507(null);
    }

    public void openAddImageScreen() {
        this.updateImagesList();
        class_310.method_1551().method_1507((class_437)new AddImageScreen(this));
    }

    public void finalizeNote() {
        this.updateImagesList();
        ModComponents.NoteComponent content = new ModComponents.NoteComponent(this.text, this.images);
        this.stack.method_57379(ModComponents.NOTE_COMPONENT_TYPE, (Object)content);
        ClientPlayNetworking.send((class_8710)new FinalizeNoteC2SPayload(this.stack));
        class_310.method_1551().method_1507(null);
    }

    public void updateImagesList() {
        this.images = new ArrayList<Image>();
        for (ImageWidget widget : this.imageWidgets) {
            if (!widget.field_22763 || !widget.field_22764) continue;
            this.images.add(new Image(widget.getImageURL(), widget.method_46426() - this.X_OFFSET, widget.method_46427() - this.Y_OFFSET, widget.method_25368(), widget.method_25364()));
        }
    }

    public void addImage(Image newImage) {
        this.images.add(newImage);
        this.imageWidgets.add(new ImageWidget(newImage, this));
        this.method_41843();
    }

    protected void method_25426() {
        this.X_OFFSET = (this.field_22789 - 128) / 2 + 4;
        for (Image image : this.images) {
            ImageWidget imageWidget = new ImageWidget(image, this);
            this.imageWidgets.add(imageWidget);
            this.method_37063((class_364)imageWidget);
        }
        this.editBox = class_7529.method_71507().method_71515(false).method_71514(-16777216).method_71516(-16777216).method_71513(false).method_71511(false).method_71508(this.X_OFFSET - 4).method_71512(this.Y_OFFSET - 4).method_71509(this.field_22793, 128, 164, class_5244.field_39003);
        this.editBox.method_44402(1024);
        this.editBox.method_71506(17);
        this.editBox.method_44401(newText -> {
            this.text = newText;
        });
        this.editBox.method_44400(this.text);
        this.method_37063((class_364)this.editBox);
        class_4185 addImageButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.notes.add_image"), button -> this.openAddImageScreen()).method_46431();
        addImageButton.method_55444(170, 20, this.field_22789 / 2 - 80 - 5, 190);
        this.method_37063((class_364)addImageButton);
        class_4185 finalizeNoteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.notes.finalize"), button -> this.finalizeNote()).method_46431();
        finalizeNoteButton.method_55444(80, 20, this.field_22789 / 2 - 80 - 5, 215);
        this.method_37063((class_364)finalizeNoteButton);
        class_4185 doneButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46431();
        doneButton.method_55444(80, 20, this.field_22789 / 2 + 5, 215);
        this.method_37063((class_364)doneButton);
    }

    protected void method_41843() {
        this.updateImagesList();
        this.imageWidgets.clear();
        super.method_41843();
    }

    protected void method_56131() {
        this.method_48265((class_364)this.editBox);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        for (int i = this.imageWidgets.size() - 1; i >= 0; --i) {
            ImageWidget widget = this.imageWidgets.get(i);
            if (!widget.field_22763 || !widget.field_22764) continue;
            widget.renderImage(context);
        }
        for (ImageWidget widget : this.imageWidgets) {
            if (NotesClient.holdingAnyImage) {
                if (!widget.isHolding()) continue;
                widget.changeCursor(context, mouseX, mouseY);
                break;
            }
            if (!widget.method_25405(mouseX, mouseY)) continue;
            widget.changeCursor(context, mouseX, mouseY);
            break;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25420(context, mouseX, mouseY, deltaTicks);
        context.method_25302(class_10799.field_56883, class_2960.method_60655((String)"notes", (String)"textures/gui/note.png"), (this.field_22789 - 128) / 2 - 16, 12, 0.0f, 0.0f, 256, 256, 256, 256, 256, 256);
    }
}

