/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Optional;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class GaussianBlur
implements class_6910,
FunctionWithCache.Simple {
    private static final MapCodec<GaussianBlur> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("kernel_radius", (Object)3).forGetter(d -> d.kernelRadius), (App)Codec.DOUBLE.optionalFieldOf("sigma", (Object)2.0).forGetter(d -> d.sigma), (App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key), (App)class_6910.field_37059.fieldOf("argument").forGetter(d -> d.argument), (App)class_6910.field_37059.fieldOf("min_x").forGetter(d -> d.minX), (App)class_6910.field_37059.fieldOf("min_z").forGetter(d -> d.minZ), (App)class_6910.field_37059.fieldOf("max_x").forGetter(d -> d.maxX), (App)class_6910.field_37059.fieldOf("max_z").forGetter(d -> d.maxZ), (App)class_6910.field_37059.optionalFieldOf("y").forGetter(d -> d.y)).apply((Applicative)instance, GaussianBlur::new));
    public static final class_7243<GaussianBlur> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final int kernelRadius;
    public final double sigma;
    public final boolean normalize;
    public final String key;
    public final class_6910 argument;
    public final class_6910 minX;
    public final class_6910 minZ;
    public final class_6910 maxX;
    public final class_6910 maxZ;
    public final Optional<class_6910> y;
    private final Cache cache;

    private GaussianBlur(int kernelRadius, double sigma, boolean normalize, String key, class_6910 argument, class_6910 minX, class_6910 minZ, class_6910 maxX, class_6910 maxZ, Optional<class_6910> y, Cache cache) {
        this.kernelRadius = kernelRadius;
        this.sigma = sigma;
        this.normalize = normalize;
        this.key = key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = cache;
    }

    public GaussianBlur(int kernelRadius, double sigma, boolean normalize, String key, class_6910 argument, class_6910 minX, class_6910 minZ, class_6910 maxX, class_6910 maxZ, Optional<class_6910> y) {
        this.kernelRadius = kernelRadius;
        this.sigma = sigma;
        this.normalize = normalize;
        this.key = key.isEmpty() ? null : key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = null;
    }

    public double method_40464(class_6910.class_6912 pos) {
        if (pos.comp_371() < this.cache.minX || pos.comp_371() > this.cache.maxX || pos.comp_373() < this.cache.minZ || pos.comp_373() > this.cache.maxZ) {
            return 0.0;
        }
        double val = this.cache.blur[pos.comp_371() - this.cache.minX][pos.comp_373() - this.cache.minZ];
        return this.normalize ? (val - this.cache.minValue) / (this.cache.maxValue - this.cache.minValue) : val;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new GaussianBlur(this.kernelRadius, this.sigma, this.normalize, this.key, this.argument.method_40469(visitor), this.minX.method_40469(visitor), this.minZ.method_40469(visitor), this.maxX.method_40469(visitor), this.maxZ.method_40469(visitor), this.y, this.cache));
    }

    public double comp_377() {
        return this.normalize || this.cache == null ? 0.0 : this.cache.minValue;
    }

    public double comp_378() {
        return this.normalize || this.cache == null ? 1.0 : this.cache.maxValue;
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int _minX, int _maxX, int _minY, int _maxY, int _minZ, int _maxZ) {
        int y = (int)this.y.map(d -> d.method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0))).orElse(0.0).doubleValue();
        int minX = (int)this.minX.method_40464((class_6910.class_6912)new class_6910.class_6914(0, y, 0));
        int maxX = (int)this.maxX.method_40464((class_6910.class_6912)new class_6910.class_6914(0, y, 0));
        int minZ = (int)this.minZ.method_40464((class_6910.class_6912)new class_6910.class_6914(0, y, 0));
        int maxZ = (int)this.maxZ.method_40464((class_6910.class_6912)new class_6910.class_6914(0, y, 0));
        int extX = maxX - minX + 1;
        int extZ = maxZ - minZ + 1;
        double[][] value = new double[extX][extZ];
        boolean[][] isZero = new boolean[extX][extZ];
        class_6910 class_69102 = this.argument;
        if (class_69102 instanceof BoundedFunction) {
            BoundedFunction maskBounds = (BoundedFunction)class_69102;
            minZ = Math.max(minZ, maskBounds.minZ());
            maxZ = Math.min(maxZ, maskBounds.maxZ());
            minX = Math.max(minX, maskBounds.minX());
            maxX = Math.min(maxX, maskBounds.maxX());
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                value[x - minX][z - minZ] = this.argument.method_40464((class_6910.class_6912)new class_6910.class_6914(x, y, z));
                isZero[x - minX][z - minZ] = value[x - minX][z - minZ] == 0.0;
            }
        }
        double[][] blur = io.github.orlouge.landmarks.utils.GaussianBlur.gaussianBlur(value, isZero, this.kernelRadius, this.sigma);
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        double[][] dArray = blur;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double col : row = dArray[i]) {
                maxValue = Math.max(col, maxValue);
                minValue = Math.min(col, minValue);
            }
        }
        return new Cache(blur, minValue, maxValue, minX, minZ, maxX, maxZ);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new GaussianBlur(this.kernelRadius, this.sigma, this.normalize, this.key, this.argument, this.minX, this.minZ, this.maxX, this.maxZ, this.y, (Cache)cache);
    }

    private record Cache(double[][] blur, double minValue, double maxValue, int minX, int minZ, int maxX, int maxZ) {
    }
}

