/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FeatureBlockMatches(List<Either<String, HolderSet<Block>>> filter, List<Either<String, HolderSet<Block>>> negativeFilter, WorldGenLevel world, List<Either<BlockStateParser.BlockResult, HolderSet<Block>>> filterCache, List<Either<BlockStateParser.BlockResult, HolderSet<Block>>> negativeFilterCache) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<FeatureBlockMatches> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.STRING.comapFlatMap(s -> s.startsWith("#") ? DataResult.error(() -> "No tags allowed here.") : DataResult.success((Object)s), s -> s), (Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK)).listOf().optionalFieldOf("matches", List.of()).forGetter(FeatureBlockMatches::filter), (App)Codec.either((Codec)Codec.STRING.comapFlatMap(s -> s.startsWith("#") ? DataResult.error(() -> "No tags allowed here.") : DataResult.success((Object)s), s -> s), (Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK)).listOf().optionalFieldOf("matches_not", List.of()).forGetter(FeatureBlockMatches::negativeFilter)).apply((Applicative)instance, FeatureBlockMatches::new));
    public static final KeyDispatchDataCodec<FeatureBlockMatches> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public FeatureBlockMatches(List<Either<String, HolderSet<Block>>> filter, List<Either<String, HolderSet<Block>>> negativeFilter) {
        this(filter, negativeFilter, null, null, null);
    }

    public FeatureBlockMatches create(WorldGenLevel world) {
        HolderLookup commandRegistryWrapper = world.holderLookup(Registries.BLOCK);
        Function<Either, Either> cache = e -> e.mapLeft(s -> {
            try {
                return BlockStateParser.parseForBlock((HolderLookup)commandRegistryWrapper, (String)s, (boolean)false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        });
        return new FeatureBlockMatches(this.filter, this.negativeFilter, world, this.filter.stream().map(cache).toList(), this.negativeFilter.stream().map(cache).toList());
    }

    public double compute(DensityFunction.FunctionContext pos) {
        BlockState requiredState;
        if (this.world == null || this.filterCache == null || this.negativeFilterCache == null) {
            throw new RuntimeException("Attempted to sample FeatureBlockMatches outside of the feature.");
        }
        BlockState state = this.world.getBlockState(new BlockPos(pos.blockX(), pos.blockY(), pos.blockZ()));
        for (Either<BlockStateParser.BlockResult, HolderSet<Block>> filter : this.filterCache) {
            if (filter.left().isPresent()) {
                requiredState = ((BlockStateParser.BlockResult)filter.left().get()).blockState();
                if (!state.is(requiredState.getBlock())) {
                    return 0.0;
                }
                for (Map.Entry property : ((BlockStateParser.BlockResult)filter.left().get()).properties().entrySet()) {
                    if (!state.hasProperty((Property)property.getKey())) {
                        return 0.0;
                    }
                    if (state.getValue((Property)property.getKey()).equals(property.getValue())) continue;
                    return 0.0;
                }
                continue;
            }
            if (!filter.right().isPresent() || ((HolderSet)filter.right().get()).contains(state.getBlockHolder())) continue;
            return 0.0;
        }
        for (Either<BlockStateParser.BlockResult, HolderSet<Block>> filter : this.negativeFilterCache) {
            if (filter.left().isPresent()) {
                requiredState = ((BlockStateParser.BlockResult)filter.left().get()).blockState();
                if (state.is(requiredState.getBlock())) {
                    return 0.0;
                }
                boolean containsAll = true;
                for (Map.Entry property : ((BlockStateParser.BlockResult)filter.left().get()).properties().entrySet()) {
                    if (state.hasProperty((Property)property.getKey()) && state.getValue((Property)property.getKey()).equals(property.getValue())) continue;
                    containsAll = false;
                    break;
                }
                if (!containsAll) continue;
                return 0.0;
            }
            if (!filter.right().isPresent() || !((HolderSet)filter.right().get()).contains(state.getBlockHolder())) continue;
            return 0.0;
        }
        return 1.0;
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

