/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.ProcessingStep;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.features.VariantWithFragment;
import io.github.orlouge.landmarks.utils.RandomProperty;
import io.github.orlouge.landmarks.utils.RandomWrapper;
import io.github.orlouge.landmarks.utils.TopologicalSort;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6910;

public record Generator(boolean skip, boolean abort, Map<String, Parameter.Sampler> parameters, Palette palette, List<ProcessingStep> processingSteps) {
    public VariantContext generate(class_5281 world, class_5819 random, VariantContext context) {
        if (this.skip || this.abort) {
            return context;
        }
        context = context.withParameters(this.parameters);
        context = context.withPalette(this.palette);
        for (ProcessingStep step : this.processingSteps) {
            step.process(world, random, context);
        }
        return context;
    }

    public record RandomizedGeneratorConfig(Optional<RandomProperty<Boolean, VariantContext, VariantContext.Predicate>> skip, Optional<RandomProperty<Boolean, VariantContext, VariantContext.Predicate>> abort, Optional<RandomProperty<Palette.RandomizedPalette, VariantContext, VariantContext.Predicate>> palette, Optional<RandomProperty<Map<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate>> userParameters, Optional<RandomProperty<List<ProcessingStep.RandomizedProcessingStep>, VariantContext, VariantContext.Predicate>> processingSteps) implements RandomWrapper<Generator, VariantContext>,
    VariantWithFragment.Fragment<RandomizedGeneratorConfig>
    {
        public static final MapCodec<RandomizedGeneratorConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("skip").forGetter(RandomizedGeneratorConfig::skip), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("abort").forGetter(RandomizedGeneratorConfig::abort), (App)VariantContext.extendRandomCodec(Palette.RandomizedPalette.CODEC).optionalFieldOf("palette").forGetter(RandomizedGeneratorConfig::palette), (App)VariantContext.wrappedRandomCodec(Codec.unboundedMap((Codec)Codec.STRING, VariantContext.wrappedRandomCodec(Parameter.CODEC, "value"))).optionalFieldOf("parameters").forGetter(RandomizedGeneratorConfig::userParameters), (App)VariantContext.strictWrappedRandomCodec(ProcessingStep.RandomizedProcessingStep.CODEC.codec().listOf(), "steps").optionalFieldOf("processing_sequence").forGetter(RandomizedGeneratorConfig::processingSteps)).apply((Applicative)i, RandomizedGeneratorConfig::new));
        public static final MapCodec<VariantWithFragment<RandomizedGeneratorConfig>> VARIANT_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, VariantContext.wrappedRandomCodec(Codec.STRING, "variant_name")).optionalFieldOf("variants", Collections.emptyMap()).forGetter(VariantWithFragment::subVariants), (App)Codec.STRING.optionalFieldOf("variant_name").forGetter(VariantWithFragment::nameOverride), (App)MAP_CODEC.forGetter(VariantWithFragment::fragment)).apply((Applicative)i, VariantWithFragment::new));
        public static final Codec<RandomProperty.WrappedEntry<VariantWithFragment<RandomizedGeneratorConfig>, VariantContext.Predicate>> RANDOM_ENTRY_CODEC = RandomProperty.WrappedEntry.extendCodec(VARIANT_MAP_CODEC, VariantContext.Predicate.CODEC);
        public static final class_5321<class_2378<RandomProperty.WrappedEntry<VariantWithFragment<RandomizedGeneratorConfig>, VariantContext.Predicate>>> REGISTRY_KEY = class_5321.method_29180((class_2960)class_2960.method_43902((String)"landmarks_worldgen", (String)"generators"));
        public static Map<class_2960, Map<String, List<RandomProperty.WrappedEntry<VariantWithFragment.NamedVariant<RandomizedGeneratorConfig>, VariantContext.Predicate>>>> childVariants = null;

        public RandomizedGeneratorConfig() {
            this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public static Map<class_2960, Map<String, List<RandomProperty.WrappedEntry<VariantWithFragment.NamedVariant<RandomizedGeneratorConfig>, VariantContext.Predicate>>>> getChildVariants(class_5455 registryManager) {
            if (childVariants == null) {
                childVariants = VariantWithFragment.getChildVariants(registryManager.method_30530(REGISTRY_KEY), new RandomizedGeneratorConfig());
            }
            return childVariants;
        }

        public static class_3545<RandomizedGeneratorConfig, VariantContext> getAndMerge(List<class_2960> variants, RandomizedGeneratorConfig baseConfig, class_5819 random, VariantContext baseContext, class_5455 registryManager) throws RandomProperty.NoRandomMatchException {
            return VariantWithFragment.getAndMerge(variants, baseConfig, new RandomizedGeneratorConfig(), random, baseContext, registryManager, REGISTRY_KEY, RandomizedGeneratorConfig.getChildVariants(registryManager));
        }

        @Override
        public RandomizedGeneratorConfig merge(RandomizedGeneratorConfig config) {
            return new RandomizedGeneratorConfig(this.skip.isPresent() && config.skip.isPresent() ? Optional.of(this.skip.get().merge(config.skip.get())) : this.skip.or(() -> config.skip), this.abort.isPresent() && config.abort.isPresent() ? Optional.of(this.abort.get().merge(config.abort.get())) : this.abort.or(() -> config.abort), this.palette.isPresent() && config.palette.isPresent() ? Optional.of(this.palette.get().merge(config.palette.get())) : this.palette.or(() -> config.palette), this.userParameters.isPresent() && config.userParameters.isPresent() ? Optional.of(this.userParameters.get().merge(config.userParameters.get())) : this.userParameters.or(() -> config.userParameters), this.processingSteps.isPresent() && config.processingSteps.isPresent() ? Optional.of(this.processingSteps.get().merge(config.processingSteps.get())) : this.processingSteps.or(() -> config.processingSteps));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Generator sample(class_5819 random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            boolean abort;
            class_6910.class_6915 visitor = context.getVisitor();
            HashMap<String, Parameter.Sampler> parameters = new HashMap<String, Parameter.Sampler>();
            if (this.userParameters.isPresent()) {
                Map<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> parameters2;
                RandomProperty.Sampler<Map<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>>> sampler = this.userParameters.get().withoutReplacement(context, false, true).sampler(random);
                HashMap<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> mergedParameters = new HashMap<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>>();
                while ((parameters2 = sampler.sample()) != null) {
                    if (parameters2.keySet().stream().anyMatch(parameters.keySet()::contains)) continue;
                    mergedParameters.putAll(parameters2);
                }
                HashMap deps = new HashMap();
                for (Map.Entry entry : mergedParameters.entrySet()) {
                    deps.put((String)entry.getKey(), ((RandomProperty)entry.getValue()).entries().stream().flatMap(w -> ((Parameter)w.value()).referencedParameters().stream()).filter(mergedParameters.keySet()::contains).collect(Collectors.toSet()));
                }
                List<String> topoParOrder = TopologicalSort.sort(deps.keySet(), deps::get);
                for (String par : topoParOrder) {
                    Parameter.Sampler value = ((Parameter)((RandomProperty)mergedParameters.get(par)).sample(random, context)).createSampler(visitor);
                    parameters.put(par, value);
                    context = context.withParameters(Map.of(par, value));
                    visitor = context.getVisitor();
                }
            }
            boolean skip = this.skip.isPresent() ? this.skip.get().sample(random, context) : false;
            boolean bl = abort = this.abort.isPresent() ? this.abort.get().sample(random, context) : false;
            if (skip || abort) {
                return new Generator(skip, abort, new HashMap<String, Parameter.Sampler>(), new Palette(), List.of());
            }
            Palette palette = new Palette();
            if (this.palette.isPresent()) {
                void var9_14;
                Palette.RandomizedPalette palette2;
                RandomProperty.Sampler<Palette.RandomizedPalette> sampler = this.palette.get().withoutReplacement(context, false, true).sampler(random);
                Palette.RandomizedPalette randomizedPalette = sampler.sample();
                while ((palette2 = sampler.sample()) != null) {
                    if (!var9_14.canCombineWithoutReplacement(palette2)) continue;
                    Palette.RandomizedPalette randomizedPalette2 = var9_14.merge(palette2);
                }
                palette = var9_14.sample(random, context);
            }
            context = context.withPalette(palette);
            LinkedHashMap<Integer, ProcessingStep> steps = new LinkedHashMap<Integer, ProcessingStep>();
            if (this.processingSteps.isPresent()) {
                List<ProcessingStep.RandomizedProcessingStep> steps2;
                RandomProperty.Sampler<List<ProcessingStep.RandomizedProcessingStep>> sampler = this.processingSteps.get().withoutReplacement(context, false, false).sampler(random);
                while ((steps2 = sampler.sample()) != null) {
                    LinkedHashMap<Integer, ProcessingStep.RandomizedProcessingStep> steps2Map = new LinkedHashMap<Integer, ProcessingStep.RandomizedProcessingStep>();
                    int lastIndex = -1;
                    for (ProcessingStep.RandomizedProcessingStep randomizedProcessingStep : steps2) {
                        int index;
                        lastIndex = index = randomizedProcessingStep.index().orElse(lastIndex + 1).intValue();
                        steps2Map.put(index, randomizedProcessingStep);
                    }
                    if (steps2Map.keySet().stream().anyMatch(steps.keySet()::contains)) continue;
                    for (Map.Entry entry : steps2Map.entrySet()) {
                        steps.put((Integer)entry.getKey(), ((ProcessingStep.RandomizedProcessingStep)entry.getValue()).sample(random, context));
                    }
                }
            }
            return new Generator(false, false, parameters, palette, steps.values().stream().toList());
        }

        @Override
        public RandomizedGeneratorConfig addVariantCondition(String variantType, String variantName) {
            return new RandomizedGeneratorConfig(this.skip.map(skip -> skip.mapPredicates(p -> p.addVariantCondition(variantType, variantName))), this.abort.map(abort -> abort.mapPredicates(p -> p.addVariantCondition(variantType, variantName))), this.palette.map(palette -> palette.mapPredicates(p -> p.addVariantCondition(variantType, variantName))), this.userParameters.map(pars -> pars.mapPredicates(p -> p.addVariantCondition(variantType, variantName))), this.processingSteps.map(steps -> steps.mapPredicates(p -> p.addVariantCondition(variantType, variantName))));
        }
    }
}

