/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.RandomProperty;
import io.github.orlouge.landmarks.utils.RandomWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6910;
import net.minecraft.class_7924;

public record Palette(Map<String, BlockTemplate> entries, Map<String, ResolvedCopiedEntry> copiedEntries) {
    public Palette() {
        this(Collections.emptyMap(), Collections.emptyMap());
    }

    public Palette merge(Palette other) {
        HashMap<String, BlockTemplate> entries = new HashMap<String, BlockTemplate>(this.entries);
        HashMap<String, ResolvedCopiedEntry> copiedEntries = new HashMap<String, ResolvedCopiedEntry>(this.copiedEntries);
        entries.putAll(other.entries);
        copiedEntries.putAll(other.copiedEntries);
        return new Palette(entries, copiedEntries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canCombineWithoutReplacement(Palette other) {
        if (!other.entries.keySet().stream().noneMatch(this.entries.keySet()::contains)) return false;
        if (!other.copiedEntries.keySet().stream().noneMatch(this.copiedEntries.keySet()::contains)) return false;
        return true;
    }

    public Either<BlockTemplate, ResolvedCopiedEntry> get(String entry, boolean strict) {
        BlockTemplate template = this.entries.get(entry);
        if (template == null) {
            ResolvedCopiedEntry copied = this.copiedEntries.get(entry);
            if (copied == null) {
                if (strict) {
                    throw new RuntimeException("Missing palette entry: " + entry);
                }
                return Either.left((Object)BlockTemplate.empty());
            }
            return Either.right((Object)copied);
        }
        return Either.left((Object)template);
    }

    public Either<BlockTemplate, ResolvedCopiedEntry> get(String entry) {
        return this.get(entry, true);
    }

    public record ResolvedCopiedEntry(Parameter.Sampler x, Parameter.Sampler y, Parameter.Sampler z, class_6885<class_2248> canCopy, boolean resetState) {
    }

    public record PalettedBlockTemplate(Either<String, BlockTemplate> referenceOrTemplate) {
        public static final Codec<PalettedBlockTemplate> CODEC = Codec.either((Codec)Codec.STRING.comapFlatMap(str -> str.startsWith("%") && !str.contains(";") && !str.contains("*") && !str.contains("?") ? DataResult.success((Object)str.substring(1)) : DataResult.error(() -> "Palette references must begin with %."), ref -> "%" + ref), BlockTemplate.CODEC).xmap(PalettedBlockTemplate::new, PalettedBlockTemplate::referenceOrTemplate);
    }

    public record RandomizedPalette(Map<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>> entries, Map<String, RandomProperty<CopiedEntry, VariantContext, VariantContext.Predicate>> copyEntries) implements RandomWrapper<Palette, VariantContext>
    {
        public static final MapCodec<RandomizedPalette> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, VariantContext.wrappedRandomCodec(PalettedBlockTemplate.CODEC, "block")).optionalFieldOf("entries", Collections.emptyMap()).forGetter(RandomizedPalette::entries), (App)Codec.unboundedMap((Codec)Codec.STRING, VariantContext.extendRandomCodec(CopiedEntry.MAP_CODEC)).optionalFieldOf("copy_entries", Collections.emptyMap()).forGetter(RandomizedPalette::copyEntries)).apply((Applicative)instance, RandomizedPalette::new));

        public RandomizedPalette() {
            this(new HashMap<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>>(), new HashMap<String, RandomProperty<CopiedEntry, VariantContext, VariantContext.Predicate>>());
        }

        public RandomizedPalette merge(RandomizedPalette other) {
            HashMap<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>> entries = new HashMap<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>>(this.entries);
            HashMap<String, RandomProperty<CopiedEntry, VariantContext, VariantContext.Predicate>> copiedEntries = new HashMap<String, RandomProperty<CopiedEntry, VariantContext, VariantContext.Predicate>>(this.copyEntries);
            entries.putAll(other.entries);
            copiedEntries.putAll(other.copyEntries);
            return new RandomizedPalette(entries, copiedEntries);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canCombineWithoutReplacement(RandomizedPalette other) {
            if (!other.entries.keySet().stream().noneMatch(this.entries.keySet()::contains)) return false;
            if (!other.copyEntries.keySet().stream().noneMatch(this.copyEntries.keySet()::contains)) return false;
            return true;
        }

        @Override
        public Palette sample(class_5819 random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            HashMap<String, BlockTemplate> resolved = new HashMap<String, BlockTemplate>();
            HashMap<String, String> unresolved = new HashMap<String, String>();
            for (Map.Entry<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>> entry : this.entries.entrySet()) {
                try {
                    PalettedBlockTemplate sampled = entry.getValue().sample(random, context);
                    sampled.referenceOrTemplate.map(str -> str.startsWith("%") ? resolved.put((String)entry.getKey(), BlockTemplate.parse("%" + str)) : unresolved.put((String)entry.getKey(), (String)str), template -> resolved.put((String)entry.getKey(), template.copy()));
                }
                catch (RandomProperty.NoRandomMatchException ignored) {
                    resolved.put(entry.getKey(), null);
                }
            }
            int lastUnresolvedCount = unresolved.size();
            int unchangedIterations = 0;
            while (!unresolved.isEmpty() && unchangedIterations < 10) {
                Iterator it = unresolved.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String reference = (String)entry.getValue();
                    if (resolved.containsKey(reference)) {
                        it.remove();
                        resolved.put((String)entry.getKey(), (BlockTemplate)resolved.get(reference));
                        continue;
                    }
                    if (unresolved.containsKey(reference)) {
                        unresolved.put((String)entry.getKey(), (String)unresolved.get(reference));
                        continue;
                    }
                    it.remove();
                    resolved.put((String)entry.getKey(), BlockTemplate.empty());
                    resolved.put(reference, BlockTemplate.empty());
                }
                if (unresolved.size() == lastUnresolvedCount) {
                    ++unchangedIterations;
                    continue;
                }
                unchangedIterations = 0;
                lastUnresolvedCount = unresolved.size();
            }
            if (!unresolved.isEmpty()) {
                throw new RuntimeException("Unresolved palette references: " + String.join((CharSequence)", ", unresolved.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).toList()) + " (generators: " + String.join((CharSequence)", ", context.variant().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList()) + ")");
            }
            HashMap<String, ResolvedCopiedEntry> copied = new HashMap<String, ResolvedCopiedEntry>();
            for (Map.Entry<String, RandomProperty<CopiedEntry, VariantContext, VariantContext.Predicate>> entry : this.copyEntries.entrySet()) {
                copied.put("%" + entry.getKey(), entry.getValue().sample(random, context).resolve(context));
            }
            return new Palette(resolved, copied);
        }
    }

    public record CopiedEntry(Either<String, Parameter> x, Either<String, Parameter> y, Either<String, Parameter> z, class_6885<class_2248> canCopy, boolean resetState) {
        public static final MapCodec<CopiedEntry> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Parameter.CODEC_NAMED.fieldOf("x").forGetter(CopiedEntry::x), (App)Parameter.CODEC_NAMED.fieldOf("y").forGetter(CopiedEntry::y), (App)Parameter.CODEC_NAMED.fieldOf("z").forGetter(CopiedEntry::z), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("can_copy").forGetter(CopiedEntry::canCopy), (App)Codec.BOOL.fieldOf("reset_state").forGetter(CopiedEntry::resetState)).apply((Applicative)instance, CopiedEntry::new));

        public ResolvedCopiedEntry resolve(VariantContext context) {
            class_6910.class_6915 visitor = context.getVisitor();
            Parameter.Sampler x = (Parameter.Sampler)this.x.map(context.userParameters()::get, par -> par.createSampler(visitor));
            Parameter.Sampler y = (Parameter.Sampler)this.y.map(context.userParameters()::get, par -> par.createSampler(visitor));
            Parameter.Sampler z = (Parameter.Sampler)this.z.map(context.userParameters()::get, par -> par.createSampler(visitor));
            return new ResolvedCopiedEntry(x, y, z, this.canCopy, this.resetState);
        }
    }
}

