/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.features.Generator;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.features.VariantWithFragment;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.RandomProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7924;

public class SurfaceNoiseFeature
extends class_3031<Config> {
    public SurfaceNoiseFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<Config> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        class_6880 biome = context.method_33652().method_23753(origin);
        class_1923 originChunk = new class_1923(origin);
        long seed = random.method_43055();
        long startTime = System.currentTimeMillis();
        int minZ = (originChunk.field_9180 - 1) * 16;
        int maxZ = (originChunk.field_9180 + 2) * 16 - 1;
        int minX = (originChunk.field_9181 - 1) * 16;
        int maxX = (originChunk.field_9181 + 2) * 16 - 1;
        int minY = world.method_31607();
        int maxY = world.method_31600();
        try {
            Generator baseGenerator;
            Config config = (Config)context.method_33656();
            boolean debug = config.debug;
            if (debug) {
                System.out.println("#################################");
                context.method_38427().flatMap(arg_0 -> ((class_2378)world.method_30349().method_30530(class_7924.field_41239)).method_29113(arg_0)).ifPresentOrElse(k -> System.out.println("Generating configured feature " + String.valueOf(k.method_29177())), () -> System.out.println("Generating surface noise feature"));
                System.out.println("  at " + String.valueOf(origin) + " (" + (String)biome.method_40229().map(k -> k.method_29177().toString(), k -> "?") + ") with seed " + seed);
            }
            class_2338 minPos = new class_2338(minX, minY, minZ);
            class_2338 maxPos = new class_2338(maxX, maxY, maxZ);
            VariantContext variantContext = new VariantContext(world, seed, (class_6880<class_1959>)biome, new HashMap<String, String>(), origin, minPos, maxPos, new HashMap<String, Parameter.Sampler>(), new HashMap<String, Object>(), new Palette());
            VariantWithFragment.VariantSampler<Generator.RandomizedGeneratorConfig> variantSampler = new VariantWithFragment.VariantSampler<Generator.RandomizedGeneratorConfig>();
            variantSampler.addUnconditionalSubvariants(config.baseGenerator);
            variantContext = variantSampler.sampleContext(random, variantContext);
            if (debug) {
                this.printContext("(Base)", variantContext);
            }
            if ((baseGenerator = config.baseGenerator.fragment().sample(random, variantContext)).abort()) {
                if (debug) {
                    System.out.println("Aborted");
                }
                return false;
            }
            if (!baseGenerator.skip()) {
                variantContext = baseGenerator.generate(world, random, variantContext);
            }
            class_6910.class_6915 visitor = variantContext.getVisitor();
            if (config.bounds.isPresent()) {
                Parameter.Sampler sampler = (Parameter.Sampler)config.bounds.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor));
                if (sampler.bounds().isPresent()) {
                    minZ = Math.max(minZ, sampler.bounds().get().minZ());
                    maxZ = Math.min(maxZ, sampler.bounds().get().maxZ());
                    minX = Math.max(minX, sampler.bounds().get().minX());
                    maxX = Math.min(maxX, sampler.bounds().get().maxX());
                    minY = Math.max(minY, sampler.bounds().get().minY());
                    maxY = Math.min(maxY, sampler.bounds().get().maxY());
                } else {
                    int _minX = maxX;
                    int _maxX = minX;
                    int _minY = maxY;
                    int _maxY = minY;
                    int _minZ = maxZ;
                    int _maxZ = minZ;
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z < maxZ; ++z) {
                                class_6910.class_6914 class_69142 = new class_6910.class_6914(x, y, z);
                                if (!(sampler.sample((class_6910.class_6912)class_69142) > 0.0)) continue;
                                if (x < _minX) {
                                    _minX = x;
                                }
                                if (x > _maxX) {
                                    _maxX = x;
                                }
                                if (y < _minY) {
                                    _minY = y;
                                }
                                if (y > _maxY) {
                                    _maxY = y;
                                }
                                if (z < _minZ) {
                                    _minZ = z;
                                }
                                if (z <= _maxZ) continue;
                                _maxZ = z;
                            }
                        }
                    }
                    minX = _minX;
                    minY = _minY;
                    minZ = _minZ;
                    maxX = _maxX;
                    maxY = _maxY;
                    maxZ = _maxZ;
                }
            }
            class_6910.class_6914 zeroPos = new class_6910.class_6914(0, 0, 0);
            if (config.minX.isPresent()) {
                minX = Math.max(minX, (int)((Parameter.Sampler)config.minX.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            if (config.minY.isPresent()) {
                minY = Math.max(minY, (int)((Parameter.Sampler)config.minY.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            if (config.minZ.isPresent()) {
                minZ = Math.max(minZ, (int)((Parameter.Sampler)config.minZ.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            if (config.maxX.isPresent()) {
                maxX = Math.min(maxX, (int)((Parameter.Sampler)config.maxX.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            if (config.maxY.isPresent()) {
                maxY = Math.min(maxY, (int)((Parameter.Sampler)config.maxY.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            if (config.maxZ.isPresent()) {
                maxZ = Math.min(maxZ, (int)((Parameter.Sampler)config.maxZ.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((class_6910.class_6912)zeroPos));
            }
            variantContext = variantContext.withBounds(minX, minY, minZ, maxX, maxY, maxZ);
            for (Either<class_2960, VariantWithFragment<Generator.RandomizedGeneratorConfig>> referenceOrGenerator : config.generators) {
                Generator generator;
                if (debug) {
                    this.printContext((String)referenceOrGenerator.map(class_2960::toString, r -> "(Anonymous)"), variantContext);
                }
                if (referenceOrGenerator.left().isPresent()) {
                    class_3545<Generator.RandomizedGeneratorConfig, VariantContext> pair = Generator.RandomizedGeneratorConfig.getAndMerge(List.of((class_2960)referenceOrGenerator.left().get()), new Generator.RandomizedGeneratorConfig(), random, variantContext, world.method_30349());
                    variantContext = (VariantContext)pair.method_15441();
                    generator = ((Generator.RandomizedGeneratorConfig)pair.method_15442()).sample(random, variantContext);
                } else {
                    VariantWithFragment randomGen = (VariantWithFragment)referenceOrGenerator.right().get();
                    VariantWithFragment.VariantSampler sampler = new VariantWithFragment.VariantSampler();
                    sampler.addUnconditionalSubvariants(randomGen);
                    variantContext = sampler.sampleContext(random, variantContext);
                    generator = ((Generator.RandomizedGeneratorConfig)randomGen.fragment()).sample(random, variantContext);
                }
                if (generator.abort()) {
                    if (debug) {
                        System.out.println("Aborted");
                    }
                    return false;
                }
                if (generator.skip()) {
                    if (!debug) continue;
                    System.out.println("Skipped");
                    continue;
                }
                variantContext = generator.generate(world, random, variantContext);
            }
            if (debug) {
                this.printContext("(Exiting)", variantContext);
            }
            if (debug) {
                System.out.println("Generated in " + (System.currentTimeMillis() - startTime) + " ms");
                System.out.println("#################################\n\n");
            }
        }
        catch (RandomProperty.NoRandomMatchException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void printContext(String generator, VariantContext variantContext) {
        System.out.println("Context for " + generator + ":");
        System.out.println("  Bounds: " + String.valueOf(variantContext.minPos()) + " -> " + String.valueOf(variantContext.maxPos()));
        if (!variantContext.variant().isEmpty()) {
            System.out.println("  Variants: " + String.join((CharSequence)", ", variantContext.variant().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList()));
        }
        if (!variantContext.userParameters().isEmpty()) {
            try {
                System.out.println("  Parameters: " + String.join((CharSequence)", ", variantContext.userParameters().entrySet().stream().map(e -> {
                    Object value;
                    try {
                        Object patt0$temp = e.getValue();
                        if (patt0$temp instanceof Parameter.Constant) {
                            Parameter.Constant cons = (Parameter.Constant)patt0$temp;
                            value = "" + cons.value;
                            if (((String)value).length() > 7) {
                                value = String.format("%.3f", cons.value);
                            }
                        } else {
                            double val;
                            double min = Double.POSITIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            double mean = 0.0;
                            double cnt = 0.0;
                            double std = 0.0;
                            for (class_2338 pos : class_2338.method_10097((class_2338)variantContext.minPos(), (class_2338)variantContext.maxPos())) {
                                val = ((Parameter.Sampler)e.getValue()).sample((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                                min = Math.min(val, min);
                                max = Math.max(val, max);
                                mean += val;
                                cnt += 1.0;
                            }
                            mean /= cnt;
                            if (max - min < 1.0E-4) {
                                value = "" + mean;
                                if (((String)value).length() > 7) {
                                    value = String.format("%.3f", mean);
                                }
                            } else {
                                for (class_2338 pos : class_2338.method_10097((class_2338)variantContext.minPos(), (class_2338)variantContext.maxPos())) {
                                    val = ((Parameter.Sampler)e.getValue()).sample((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                                    std += (val - mean) * (val - mean);
                                }
                                std = Math.sqrt(std / cnt);
                                value = String.format("%.3f\u00b1%.2f \u2208 [%.2f,%.2f]", mean, std, min, max);
                            }
                        }
                    }
                    catch (Exception ex) {
                        value = ex.getMessage();
                    }
                    return (String)e.getKey() + " = " + (String)value;
                }).toList()));
            }
            catch (Exception ex) {
                System.out.println("  Parameters: ERROR");
                ex.printStackTrace();
            }
        }
        if (!variantContext.palette().entries().isEmpty() || !variantContext.palette().copiedEntries().isEmpty()) {
            System.out.println("  Palette: " + String.join((CharSequence)", ", variantContext.palette().entries().entrySet().stream().map(e -> (String)e.getKey() + " = " + ((BlockTemplate)e.getValue()).toString()).toList()) + " | " + String.join((CharSequence)",", variantContext.palette().copiedEntries().keySet()));
        }
    }

    public record Config(List<Either<class_2960, VariantWithFragment<Generator.RandomizedGeneratorConfig>>> generators, VariantWithFragment<Generator.RandomizedGeneratorConfig> baseGenerator, Optional<Either<String, Parameter>> minX, Optional<Either<String, Parameter>> minY, Optional<Either<String, Parameter>> minZ, Optional<Either<String, Parameter>> maxX, Optional<Either<String, Parameter>> maxY, Optional<Either<String, Parameter>> maxZ, Optional<Either<String, Parameter>> bounds, boolean debug) implements class_3037
    {
        public static final MapCodec<Config> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)class_2960.field_25139, (Codec)Generator.RandomizedGeneratorConfig.VARIANT_MAP_CODEC.codec()).listOf().optionalFieldOf("generators", Collections.emptyList()).forGetter(Config::generators), (App)Generator.RandomizedGeneratorConfig.VARIANT_MAP_CODEC.forGetter(Config::baseGenerator), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_x").forGetter(Config::minX), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_y").forGetter(Config::minY), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_z").forGetter(Config::minZ), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_x").forGetter(Config::maxX), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_y").forGetter(Config::maxY), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_z").forGetter(Config::maxZ), (App)Parameter.CODEC_NAMED.optionalFieldOf("bounds").forGetter(Config::bounds), (App)Codec.BOOL.optionalFieldOf("debug", (Object)false).forGetter(Config::debug)).apply((Applicative)instance, Config::new));
    }
}

