/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class FeatureCache
implements class_6910 {
    public static final MapCodec<FeatureCache> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("argument").forGetter(d -> d.argument), (App)Codec.STRING.fieldOf("key").forGetter(d -> d.key), (App)Codec.BOOL.optionalFieldOf("y2d", (Object)false).forGetter(d -> d.y2d)).apply((Applicative)instance, FeatureCache::new));
    public static final class_7243<FeatureCache> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final class_6910 argument;
    public final String key;
    public final boolean y2d;
    private final double[] cache;
    private final int cacheMinX;
    private final int cacheMaxX;
    private final int cacheMinY;
    private final int cacheMaxY;
    private final int cacheMinZ;
    private final int cacheMaxZ;
    private final int xExt;
    private final int zExt;

    public FeatureCache(class_6910 argument, String key, boolean y2d, double[] cache, int cacheMinX, int cacheMaxX, int cacheMinY, int cacheMaxY, int cacheMinZ, int cacheMaxZ) {
        this.argument = argument;
        this.key = key;
        this.y2d = y2d;
        this.cache = cache;
        this.cacheMinX = cacheMinX;
        this.cacheMaxX = cacheMaxX;
        this.cacheMinY = cacheMinY;
        this.cacheMaxY = cacheMaxY;
        this.cacheMinZ = cacheMinZ;
        this.cacheMaxZ = cacheMaxZ;
        this.xExt = cacheMaxX - cacheMinX + 1;
        this.zExt = cacheMaxZ - cacheMinZ + 1;
    }

    public FeatureCache(class_6910 argument, String key, boolean y2d) {
        this.argument = argument;
        this.key = key;
        this.y2d = y2d;
        this.cache = null;
        this.cacheMinX = 0;
        this.cacheMaxX = 0;
        this.cacheMinY = 0;
        this.cacheMaxY = 0;
        this.cacheMinZ = 0;
        this.cacheMaxZ = 0;
        this.xExt = 0;
        this.zExt = 0;
    }

    public FeatureCache create(double[] cache, int cacheMinX, int cacheMaxX, int cacheMinY, int cacheMaxY, int cacheMinZ, int cacheMaxZ) {
        Arrays.fill(cache, Double.NaN);
        return new FeatureCache(this.argument, this.key, this.y2d, cache, cacheMinX, cacheMaxX, cacheMinY, cacheMaxY, cacheMinZ, cacheMaxZ);
    }

    public double method_40464(class_6910.class_6912 pos) {
        if (this.cache == null || pos.comp_371() < this.cacheMinX || pos.comp_371() > this.cacheMaxX || !this.y2d && (pos.comp_372() < this.cacheMinY || pos.comp_372() > this.cacheMaxY) || pos.comp_373() < this.cacheMinZ || pos.comp_373() > this.cacheMaxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.comp_371() - this.cacheMinX;
        int cacheY = pos.comp_372() - this.cacheMinY;
        int cacheZ = pos.comp_373() - this.cacheMinZ;
        int idx = !this.y2d ? (this.xExt * cacheY + cacheX) * this.zExt + cacheZ : this.zExt * cacheX + cacheZ;
        double cachedValue = this.cache[idx];
        if (Double.isNaN(cachedValue)) {
            this.cache[idx] = cachedValue = this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private double sampleWithoutCache(class_6910.class_6912 pos) {
        return this.argument.method_40464(pos);
    }

    public double comp_377() {
        return this.argument.comp_377();
    }

    public double comp_378() {
        return this.argument.comp_378();
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new FeatureCache(this.argument.method_40469(visitor), this.key, this.y2d, this.cache, this.cacheMinX, this.cacheMaxX, this.cacheMinY, this.cacheMaxY, this.cacheMinZ, this.cacheMaxZ));
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}

