/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class Noise2D
implements class_6910 {
    public static final MapCodec<Noise2D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)class_6910.field_37059).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise2D::new));
    public static final class_7243<Noise2D> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final Either<Double, class_6910> xzScale;
    public final long seed;
    private final double[][] cache;
    private final int cacheMinX;
    private final int cacheMaxX;
    private final int cacheMinZ;
    private final int cacheMaxZ;

    public Noise2D(Either<Double, class_6910> xzScale, long seed, double[][] cache, int cacheMinX, int cacheMaxX, int cacheMinZ, int cacheMaxZ) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = cache;
        this.cacheMinX = cacheMinX;
        this.cacheMaxX = cacheMaxX;
        this.cacheMinZ = cacheMinZ;
        this.cacheMaxZ = cacheMaxZ;
    }

    public Noise2D(Either<Double, class_6910> xzScale, long seed) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = null;
        this.cacheMinX = 0;
        this.cacheMaxX = 0;
        this.cacheMinZ = 0;
        this.cacheMaxZ = 0;
    }

    public Noise2D create(long featureSeed, double[][] cache, int cacheMinX, int cacheMaxX, int cacheMinZ, int cacheMaxZ) {
        for (int x = 0; x < cache.length; ++x) {
            for (int z = 0; z < cache[0].length; ++z) {
                cache[x][z] = Double.NaN;
            }
        }
        return new Noise2D(this.xzScale, this.seed + featureSeed, cache, cacheMinX, cacheMaxX, cacheMinZ, cacheMaxZ);
    }

    public double method_40464(class_6910.class_6912 pos) {
        int cacheZ;
        if (this.cache == null || pos.comp_371() < this.cacheMinX || pos.comp_371() > this.cacheMaxX || pos.comp_373() < this.cacheMinZ || pos.comp_373() > this.cacheMaxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.comp_371() - this.cacheMinX;
        double cachedValue = this.cache[cacheX][cacheZ = pos.comp_373() - this.cacheMinZ];
        if (Double.isNaN(cachedValue)) {
            this.cache[cacheX][cacheZ] = cachedValue = (double)this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private float sampleWithoutCache(class_6910.class_6912 pos) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.method_40464(pos));
        double x2 = (double)((long)pos.comp_371() + (this.seed & 0xFFFFL)) * xzScale;
        double z = (double)((long)pos.comp_373() + (this.seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise2(this.seed, x2, z);
    }

    public double comp_377() {
        return -1.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new Noise2D((Either<Double, class_6910>)this.xzScale.mapRight(d -> d.method_40469(visitor)), this.seed, this.cache, this.cacheMinX, this.cacheMaxX, this.cacheMinZ, this.cacheMaxZ));
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}

